/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;

public interface FrameLineSegment2DReadOnly
extends LineSegment2DReadOnly,
EuclidFrameGeometry {
    public FramePoint2DReadOnly getFirstEndpoint();

    public FramePoint2DReadOnly getSecondEndpoint();

    default public void get(FixedFramePoint2DBasics firstEndpointToPack, Point2DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(firstEndpointToPack);
        super.get((Point2DBasics)firstEndpointToPack, secondEndpointToPack);
    }

    default public void get(FramePoint2DBasics firstEndpointToPack, Point2DBasics secondEndpointToPack) {
        firstEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point2DBasics)firstEndpointToPack, secondEndpointToPack);
    }

    default public void get(Point2DBasics firstEndpointToPack, FixedFramePoint2DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(secondEndpointToPack);
        super.get(firstEndpointToPack, (Point2DBasics)secondEndpointToPack);
    }

    default public void get(Point2DBasics firstEndpointToPack, FramePoint2DBasics secondEndpointToPack) {
        secondEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get(firstEndpointToPack, (Point2DBasics)secondEndpointToPack);
    }

    default public void get(FixedFramePoint2DBasics firstEndpointToPack, FixedFramePoint2DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(firstEndpointToPack, secondEndpointToPack);
        super.get((Point2DBasics)firstEndpointToPack, (Point2DBasics)secondEndpointToPack);
    }

    default public void get(FramePoint2DBasics firstEndpointToPack, FramePoint2DBasics secondEndpointToPack) {
        firstEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        secondEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point2DBasics)firstEndpointToPack, (Point2DBasics)secondEndpointToPack);
    }

    default public FramePoint2DBasics midpoint() {
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.midpoint());
    }

    default public void midpoint(FixedFramePoint2DBasics midpointToPack) {
        this.checkReferenceFrameMatch(midpointToPack);
        super.midpoint((Point2DBasics)midpointToPack);
    }

    default public void midpoint(FramePoint2DBasics midpointToPack) {
        midpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.midpoint((Point2DBasics)midpointToPack);
    }

    default public boolean isPointOnLineSegment(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLineSegment((Point2DReadOnly)point);
    }

    default public boolean isPointOnLineSegment(FramePoint2DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLineSegment((Point2DReadOnly)point, epsilon);
    }

    default public boolean isBetweenEndpoints(FramePoint2DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isBetweenEndpoints((Point2DReadOnly)point, epsilon);
    }

    default public boolean isBetweenEndpoints(FramePoint2DReadOnly point) {
        return this.isBetweenEndpoints(point, 0.0);
    }

    default public boolean isPointOnLeftSideOfLineSegment(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLeftSideOfLineSegment((Point2DReadOnly)point);
    }

    default public FrameVector2DBasics direction(boolean normalize) {
        return new FrameVector2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.direction(normalize));
    }

    default public void direction(boolean normalize, FixedFrameVector2DBasics directionToPack) {
        this.checkReferenceFrameMatch(directionToPack);
        super.direction(normalize, (Vector2DBasics)directionToPack);
    }

    default public void direction(boolean normalize, FrameVector2DBasics directionToPack) {
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.direction(normalize, (Vector2DBasics)directionToPack);
    }

    default public double distance(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distance((Point2DReadOnly)point);
    }

    default public double distanceSquared(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distanceSquared((Point2DReadOnly)point);
    }

    default public boolean isPointOnRightSideOfLineSegment(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnRightSideOfLineSegment((Point2DReadOnly)point);
    }

    default public double percentageAlongLineSegment(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.percentageAlongLineSegment((Point2DReadOnly)point);
    }

    default public double dotProduct(FrameLineSegment2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.dotProduct((LineSegment2DReadOnly)other);
    }

    default public boolean orthogonalProjection(FixedFramePoint2DBasics pointToProject) {
        return this.orthogonalProjection((FramePoint2DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(projectionToPack);
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject, projectionToPack);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public FramePoint2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.orthogonalProjectionCopy(pointToProject));
    }

    default public FramePoint2D orthogonalProjectionCopy(FramePoint2DReadOnly pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.orthogonalProjectionCopy((Point2DReadOnly)pointToProject));
    }

    default public FramePoint2DBasics intersectionWith(Line2DReadOnly line) {
        Point2DBasics intersection = super.intersectionWith(line);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public boolean intersectionWith(Line2DReadOnly line, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(intersectionToPack);
        return super.intersectionWith(line, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(Line2DReadOnly line, FramePoint2DBasics intersectionToPack) {
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(line, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly line, Point2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(line);
        return super.intersectionWith((Line2DReadOnly)line, intersectionToPack);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly line, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(line, intersectionToPack);
        return super.intersectionWith((Line2DReadOnly)line, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly line, FramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(line);
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((Line2DReadOnly)line, (Point2DBasics)intersectionToPack);
    }

    default public FramePoint2D intersectionWith(FrameLine2DReadOnly line) {
        this.checkReferenceFrameMatch(line);
        Point2DBasics intersection = super.intersectionWith((Line2DReadOnly)line);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public void perpendicular(boolean normalize, FixedFrameVector2DBasics perpendicularVectorToPack) {
        this.checkReferenceFrameMatch(perpendicularVectorToPack);
        super.perpendicular(normalize, (Vector2DBasics)perpendicularVectorToPack);
    }

    default public void perpendicular(boolean normalize, FrameVector2DBasics perpendicularVectorToPack) {
        perpendicularVectorToPack.setReferenceFrame(this.getReferenceFrame());
        super.perpendicular(normalize, (Vector2DBasics)perpendicularVectorToPack);
    }

    default public FramePoint2DBasics intersectionWith(LineSegment2DReadOnly other) {
        Point2DBasics intersection = super.intersectionWith(other);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public FramePoint2D intersectionWith(FrameLineSegment2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        Point2DBasics intersection = super.intersectionWith((LineSegment2DReadOnly)other);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly other, Point2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(other);
        return super.intersectionWith((LineSegment2DReadOnly)other, intersectionToPack);
    }

    default public boolean intersectionWith(LineSegment2DReadOnly other, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(intersectionToPack);
        return super.intersectionWith(other, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(LineSegment2DReadOnly other, FramePoint2DBasics intersectionToPack) {
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(other, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly other, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(other, intersectionToPack);
        return super.intersectionWith((LineSegment2DReadOnly)other, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly other, FramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(other);
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((LineSegment2DReadOnly)other, (Point2DBasics)intersectionToPack);
    }

    default public FramePoint2DBasics pointBetweenEndpointsGivenPercentage(double percentage) {
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.pointBetweenEndpointsGivenPercentage(percentage));
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, FixedFramePoint2DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointBetweenEndpointsGivenPercentage(percentage, (Point2DBasics)pointToPack);
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, FramePoint2DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointBetweenEndpointsGivenPercentage(percentage, (Point2DBasics)pointToPack);
    }

    default public FramePoint2DBasics[] intersectionWith(ConvexPolygon2DReadOnly convexPolygon) {
        Point2DBasics[] intersections = super.intersectionWith(convexPolygon);
        if (intersections == null) {
            return null;
        }
        FramePoint2DBasics[] frameIntersections = new FramePoint2D[intersections.length];
        for (int i = 0; i < intersections.length; ++i) {
            frameIntersections[i] = new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersections[i]);
        }
        return frameIntersections;
    }

    default public FramePoint2DBasics[] intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon) {
        this.checkReferenceFrameMatch(convexPolygon);
        return this.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack);
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, firstIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(secondIntersectionToPack);
        return super.intersectionWith(convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, secondIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public FramePoint2DBasics pointOnLineGivenPercentage(double percentage) {
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.pointOnLineGivenPercentage(percentage));
    }

    default public void pointOnLineGivenPercentage(double percentage, FixedFramePoint2DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointOnLineGivenPercentage(percentage, (Point2DBasics)pointToPack);
    }

    default public void pointOnLineGivenPercentage(double percentage, FramePoint2DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointOnLineGivenPercentage(percentage, (Point2DBasics)pointToPack);
    }

    default public String toString(String format) {
        return EuclidFrameIOTools.getFrameLineSegment2DString(format, this);
    }
}

