/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameCommonMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface FixedFrameMatrix3DBasics
extends FrameMatrix3DReadOnly,
Matrix3DBasics,
Transformable,
FixedFrameCommonMatrix3DBasics {
    default public void set(ReferenceFrame referenceFrame, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix3DReadOnly) {
        super.set(matrix3DReadOnly);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), this);
    }

    default public void setMatchingFrame(FrameMatrix3DReadOnly other) {
        this.setMatchingFrame(other.getReferenceFrame(), other);
    }

    default public void setToTildeForm(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setToTildeForm(tuple3DReadOnly);
    }

    default public void setToTildeForm(FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this.setToTildeForm(frameTuple3DReadOnly.getReferenceFrame(), frameTuple3DReadOnly);
    }

    default public void setToDiagonal(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setToDiagonal(tuple3DReadOnly);
    }

    default public void setToDiagonal(FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this.setToDiagonal(frameTuple3DReadOnly.getReferenceFrame(), frameTuple3DReadOnly);
    }

    default public void setAndMultiplyOuter(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setAndMultiplyOuter(matrix3DReadOnly);
    }

    default public void setAndMultiplyOuter(FrameMatrix3DReadOnly other) {
        this.setAndMultiplyOuter(other.getReferenceFrame(), other);
    }

    default public void setAndMultiplyInner(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setAndMultiplyInner(matrix3DReadOnly);
    }

    default public void setAndMultiplyInner(FrameMatrix3DReadOnly other) {
        this.setAndMultiplyInner(other.getReferenceFrame(), other);
    }

    default public void setAndNegate(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setAndNegate(matrix3DReadOnly);
    }

    default public void setAndNegate(FrameMatrix3DReadOnly other) {
        this.setAndNegate(other.getReferenceFrame(), other);
    }

    default public void setRow(int row, ReferenceFrame referenceFrame, Tuple3DReadOnly rowValues) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setRow(row, rowValues);
    }

    default public void setRow(int row, FrameTuple3DReadOnly rowValues) {
        this.setRow(row, rowValues.getReferenceFrame(), rowValues);
    }

    default public void setColumn(int column, ReferenceFrame referenceFrame, Tuple3DReadOnly columnValues) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setColumn(column, columnValues);
    }

    default public void setColumn(int column, FrameTuple3DReadOnly columnValues) {
        this.setColumn(column, columnValues.getReferenceFrame(), columnValues);
    }

    default public void add(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.add((Matrix3DReadOnly)other);
    }

    default public void add(FrameMatrix3DReadOnly matrix1, Matrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix1);
        super.add((Matrix3DReadOnly)matrix1, matrix2);
    }

    default public void add(Matrix3DReadOnly matrix1, FrameMatrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix2);
        super.add(matrix1, (Matrix3DReadOnly)matrix2);
    }

    default public void add(FrameMatrix3DReadOnly matrix1, FrameMatrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix1, matrix2);
        super.add((Matrix3DReadOnly)matrix1, (Matrix3DReadOnly)matrix2);
    }

    default public void sub(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.sub((Matrix3DReadOnly)other);
    }

    default public void sub(FrameMatrix3DReadOnly matrix1, Matrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix1);
        super.sub((Matrix3DReadOnly)matrix1, matrix2);
    }

    default public void sub(Matrix3DReadOnly matrix1, FrameMatrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix2);
        super.sub(matrix1, (Matrix3DReadOnly)matrix2);
    }

    default public void sub(FrameMatrix3DReadOnly matrix1, FrameMatrix3DReadOnly matrix2) {
        this.checkReferenceFrameMatch(matrix1, matrix2);
        super.sub((Matrix3DReadOnly)matrix1, (Matrix3DReadOnly)matrix2);
    }

    default public void multiply(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiply((Matrix3DReadOnly)other);
    }

    default public void multiplyTransposeThis(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeThis((Matrix3DReadOnly)other);
    }

    default public void multiplyTransposeOther(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeOther((Matrix3DReadOnly)other);
    }

    default public void multiplyTransposeBoth(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeBoth((Matrix3DReadOnly)other);
    }

    default public void multiplyInvertThis(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyInvertThis((Matrix3DReadOnly)other);
    }

    default public void multiplyInvertOther(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyInvertOther((Matrix3DReadOnly)other);
    }

    default public void multiplyInvertOther(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyInvertOther((RotationMatrixReadOnly)other);
    }

    default public void preMultiply(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiply((Matrix3DReadOnly)other);
    }

    default public void preMultiplyTransposeThis(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeThis((Matrix3DReadOnly)other);
    }

    default public void preMultiplyTransposeOther(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeOther((Matrix3DReadOnly)other);
    }

    default public void preMultiplyTransposeBoth(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeBoth((Matrix3DReadOnly)other);
    }

    default public void preMultiplyInvertThis(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyInvertThis((Matrix3DReadOnly)other);
    }

    default public void preMultiplyInvertOther(FrameMatrix3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyInvertOther((Matrix3DReadOnly)other);
    }

    default public void preMultiplyInvertOther(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        Matrix3DTools.multiplyInvertLeft((RotationMatrixReadOnly)other, (Matrix3DReadOnly)this, (CommonMatrix3DBasics)this);
    }
}

