/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface FixedFramePose2DBasics
extends FramePose2DReadOnly,
Pose2DBasics {
    @Override
    public FixedFrameOrientation2DBasics getOrientation();

    @Override
    public FixedFramePoint2DBasics getPosition();

    default public void setFromReferenceFrame(ReferenceFrame referenceFrame) {
        this.setToZero();
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void set(ReferenceFrame referenceFrame, Pose2DReadOnly pose2DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose2DReadOnly);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose3DReadOnly);
    }

    default public void set(FramePose2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.set((Pose2DReadOnly)other);
    }

    default public void setMatchingFrame(FramePose2DReadOnly other) {
        super.set((Pose2DReadOnly)other);
        other.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void set(FramePose3DReadOnly framePose3DReadOnly) {
        this.checkReferenceFrameMatch(framePose3DReadOnly);
        super.set((Pose3DReadOnly)framePose3DReadOnly);
    }

    default public void set(FrameTuple2DReadOnly position, double yaw) {
        this.checkReferenceFrameMatch(position);
        super.set((Tuple2DReadOnly)position, yaw);
    }

    default public void set(FrameTuple2DReadOnly position, Orientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(position);
        super.set((Tuple2DReadOnly)position, orientation);
    }

    default public void set(Tuple2DReadOnly position, FrameOrientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.set(position, (Orientation2DReadOnly)orientation);
    }

    default public void set(FrameTuple2DReadOnly position, FrameOrientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(position, orientation);
        super.set((Tuple2DReadOnly)position, (Orientation2DReadOnly)orientation);
    }

    default public void prependRotation(FrameOrientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.prependRotation((Orientation2DReadOnly)orientation);
    }

    default public void prependTranslation(FrameTuple2DReadOnly translation) {
        this.checkReferenceFrameMatch(translation);
        super.prependTranslation((Tuple2DReadOnly)translation);
    }

    default public void appendRotation(FrameOrientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.appendRotation((Orientation2DReadOnly)orientation);
    }

    default public void appendTranslation(FrameTuple2DReadOnly translation) {
        this.checkReferenceFrameMatch(translation);
        super.appendTranslation((Tuple2DReadOnly)translation);
    }

    default public void interpolate(FramePose2DReadOnly other, double alpha) {
        this.checkReferenceFrameMatch(other);
        super.interpolate((Pose2DReadOnly)other, alpha);
    }

    default public void interpolate(FramePose2DReadOnly pose1, Pose2DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose1);
        super.interpolate((Pose2DReadOnly)pose1, pose2, alpha);
    }

    default public void interpolate(Pose2DReadOnly pose1, FramePose2DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose2);
        super.interpolate(pose1, (Pose2DReadOnly)pose2, alpha);
    }

    default public void interpolate(FramePose2DReadOnly pose1, FramePose2DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose1, pose2);
        super.interpolate((Pose2DReadOnly)pose1, (Pose2DReadOnly)pose2, alpha);
    }
}

