/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector4DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public interface FrameMatrix3DReadOnly
extends Matrix3DReadOnly,
ReferenceFrameHolder {
    default public void getColumn(int column, FixedFrameTuple3DBasics columnToPack) {
        this.checkReferenceFrameMatch(columnToPack);
        super.getColumn(column, (Tuple3DBasics)columnToPack);
    }

    default public void getColumn(int column, FrameTuple3DBasics columnToPack) {
        columnToPack.setReferenceFrame(this.getReferenceFrame());
        super.getColumn(column, (Tuple3DBasics)columnToPack);
    }

    default public void getRow(int row, FixedFrameTuple3DBasics rowToPack) {
        this.checkReferenceFrameMatch(rowToPack);
        super.getRow(row, (Tuple3DBasics)rowToPack);
    }

    default public void getRow(int row, FrameTuple3DBasics rowToPack) {
        rowToPack.setReferenceFrame(this.getReferenceFrame());
        super.getRow(row, (Tuple3DBasics)rowToPack);
    }

    default public void transform(FixedFrameTuple3DBasics tupleToTransform) {
        this.transform((FrameTuple3DReadOnly)tupleToTransform, tupleToTransform);
    }

    default public void transform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.transform((Tuple3DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.transform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void addTransform(FixedFrameTuple3DBasics tupleToTransform) {
        this.addTransform((FrameTuple3DReadOnly)tupleToTransform, tupleToTransform);
    }

    default public void addTransform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.addTransform((Tuple3DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void addTransform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.addTransform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void addTransform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void subTransform(FixedFrameTuple3DBasics tupleToTransform) {
        this.subTransform((FrameTuple3DReadOnly)tupleToTransform, tupleToTransform);
    }

    default public void subTransform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.subTransform((Tuple3DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void subTransform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.subTransform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void subTransform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.subTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(FixedFrameTuple2DBasics tupleToTransform) {
        this.transform((FrameTuple2DReadOnly)tupleToTransform, tupleToTransform, true);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    default public void transform(FixedFrameTuple2DBasics tupleToTransform, boolean checkIfTransformInXYPlane) {
        this.transform((FrameTuple2DReadOnly)tupleToTransform, tupleToTransform, checkIfTransformInXYPlane);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfRotationInXYPlane) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.transform((Tuple2DReadOnly)tupleOriginal, tupleTransformed, checkIfRotationInXYPlane);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed, boolean checkIfRotationInXYPlane) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.transform(tupleOriginal, (Tuple2DBasics)tupleTransformed, checkIfRotationInXYPlane);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed, boolean checkIfRotationInXYPlane) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed, checkIfRotationInXYPlane);
    }

    default public void transform(FixedFrameMatrix3DBasics matrixToTransform) {
        this.transform((FrameMatrix3DReadOnly)matrixToTransform, matrixToTransform);
    }

    default public void transform(FrameMatrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixOriginal);
        this.transform(matrixOriginal, matrixTransformed);
    }

    default public void transform(Matrix3DReadOnly matrixOriginal, FixedFrameMatrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixTransformed);
        this.transform(matrixOriginal, matrixTransformed);
    }

    default public void transform(FrameMatrix3DReadOnly matrixOriginal, FixedFrameMatrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixOriginal);
        this.checkReferenceFrameMatch(matrixTransformed);
        this.transform(matrixOriginal, matrixTransformed);
    }

    default public void transform(FixedFrameVector4DBasics vectorToTransform) {
        this.transform((FrameVector4DReadOnly)vectorToTransform, vectorToTransform);
    }

    default public void transform(FrameVector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorOriginal);
        super.transform((Vector4DReadOnly)vectorOriginal, vectorTransformed);
    }

    default public void transform(Vector4DReadOnly vectorOriginal, FixedFrameVector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorTransformed);
        super.transform(vectorOriginal, (Vector4DBasics)vectorTransformed);
    }

    default public void transform(FrameVector4DReadOnly vectorOriginal, FixedFrameVector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorOriginal, vectorTransformed);
        super.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorTransformed);
    }

    default public void inverseTransform(FixedFrameTuple3DBasics tupleToTransform) {
        this.inverseTransform((FrameTuple3DReadOnly)tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        this.inverseTransform(tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        this.inverseTransform(tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        this.inverseTransform(tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(FixedFrameTuple2DBasics tupleToTransform) {
        this.inverseTransform((FrameTuple2DReadOnly)tupleToTransform, tupleToTransform, true);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    default public void inverseTransform(FixedFrameTuple2DBasics tupleToTransform, boolean checkIfTransformInXYPlane) {
        this.inverseTransform((FrameTuple2DReadOnly)tupleToTransform, tupleToTransform, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        this.checkReferenceFrameMatch(tupleOriginal);
        this.inverseTransform(tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        this.checkReferenceFrameMatch(tupleTransformed);
        this.inverseTransform(tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        this.inverseTransform(tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(FixedFrameMatrix3DBasics matrixToTransform) {
        this.inverseTransform((FrameMatrix3DReadOnly)matrixToTransform, matrixToTransform);
    }

    default public void inverseTransform(FrameMatrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixOriginal);
        this.inverseTransform(matrixOriginal, matrixTransformed);
    }

    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, FixedFrameMatrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixTransformed);
        this.inverseTransform(matrixOriginal, matrixTransformed);
    }

    default public void inverseTransform(FrameMatrix3DReadOnly matrixOriginal, FixedFrameMatrix3DBasics matrixTransformed) {
        this.checkReferenceFrameMatch(matrixOriginal, matrixTransformed);
        this.inverseTransform(matrixOriginal, matrixTransformed);
    }

    default public void inverseTransform(FixedFrameVector4DBasics vectorToTransform) {
        this.inverseTransform((FrameVector4DReadOnly)vectorToTransform, vectorToTransform);
    }

    default public void inverseTransform(FrameVector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorOriginal);
        this.inverseTransform(vectorOriginal, vectorTransformed);
    }

    default public void inverseTransform(Vector4DReadOnly vectorOriginal, FixedFrameVector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorTransformed);
        this.inverseTransform(vectorOriginal, vectorTransformed);
    }

    default public void inverseTransform(FrameVector4DReadOnly vectorOriginal, FixedFrameVector4DBasics vectorTransformed) {
        this.checkReferenceFrameMatch(vectorOriginal, vectorTransformed);
        this.inverseTransform(vectorOriginal, vectorTransformed);
    }

    default public boolean equals(FrameMatrix3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.equals((Matrix3DReadOnly)other);
    }

    default public boolean epsilonEquals(FrameMatrix3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Matrix3DReadOnly)other, epsilon);
    }
}

