/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameCommonMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;

public interface FixedFrameRotationMatrixBasics
extends FrameRotationMatrixReadOnly,
RotationMatrixBasics,
FixedFrameCommonMatrix3DBasics,
FixedFrameOrientation3DBasics {
    default public void setAndNormalize(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.setAndNormalize((RotationMatrixReadOnly)other);
    }

    @Override
    default public void set(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.set(orientation);
    }

    @Override
    default public void set(FrameOrientation3DReadOnly orientation) {
        this.set(orientation.getReferenceFrame(), orientation);
    }

    default public void setAndInvert(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.setAndInvert((RotationMatrixReadOnly)other);
    }

    @Override
    default public void setAndInvert(FrameOrientation3DReadOnly orientation) {
        FixedFrameOrientation3DBasics.super.setAndInvert(orientation);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix) {
        this.set(matrix);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameMatrix3DReadOnly matrix) {
        this.setMatchingFrame(matrix.getReferenceFrame(), matrix);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RotationMatrixReadOnly other) {
        this.set(other);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameRotationMatrixReadOnly other) {
        this.setMatchingFrame(other.getReferenceFrame(), other);
    }

    @Override
    default public void setMatchingFrame(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation) {
        super.set(orientation);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    @Override
    default public void setMatchingFrame(FrameOrientation3DReadOnly orientation) {
        this.set(orientation);
        orientation.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void multiply(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiply((RotationMatrixReadOnly)other);
    }

    default public void multiplyTransposeThis(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeThis((RotationMatrixReadOnly)other);
    }

    default public void multiplyTransposeOther(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeOther((RotationMatrixReadOnly)other);
    }

    default public void multiplyTransposeBoth(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.multiplyTransposeBoth((RotationMatrixReadOnly)other);
    }

    default public void preMultiply(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiply((RotationMatrixReadOnly)other);
    }

    default public void preMultiplyTransposeThis(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeThis((RotationMatrixReadOnly)other);
    }

    default public void preMultiplyTransposeOther(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeOther((RotationMatrixReadOnly)other);
    }

    default public void preMultiplyTransposeBoth(FrameRotationMatrixReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.preMultiplyTransposeBoth((RotationMatrixReadOnly)other);
    }

    default public void interpolate(FrameRotationMatrixReadOnly rf, double alpha) {
        this.checkReferenceFrameMatch(rf);
        super.interpolate((RotationMatrixReadOnly)rf, alpha);
    }

    default public void interpolate(RotationMatrixReadOnly r0, FrameRotationMatrixReadOnly rf, double alpha) {
        this.checkReferenceFrameMatch(rf);
        super.interpolate(r0, (RotationMatrixReadOnly)rf, alpha);
    }

    default public void interpolate(FrameRotationMatrixReadOnly r0, RotationMatrixReadOnly rf, double alpha) {
        this.checkReferenceFrameMatch(r0);
        super.interpolate((RotationMatrixReadOnly)r0, rf, alpha);
    }

    default public void interpolate(FrameRotationMatrixReadOnly r0, FrameRotationMatrixReadOnly rf, double alpha) {
        this.checkReferenceFrameMatch(r0, rf);
        super.interpolate((RotationMatrixReadOnly)r0, (RotationMatrixReadOnly)rf, alpha);
    }
}

