/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.api;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.RandomFrameTypeBuilder;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public class ReflectionBasedBuilder {
    private final Map<Class<?>, RandomFrameTypeBuilder> frameTypeBuilders = new HashMap();
    private final Map<Class<?>, RandomFramelessTypeBuilder> framelessTypeBuilders = new HashMap();

    public ReflectionBasedBuilder() {
        this.framelessTypeBuilders.put(Double.TYPE, random -> EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
        this.framelessTypeBuilders.put(Float.TYPE, random -> Float.valueOf((float)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0)));
        this.framelessTypeBuilders.put(Boolean.TYPE, random -> random.nextBoolean());
        this.framelessTypeBuilders.put(Integer.TYPE, random -> random.nextInt(1000) - 500);
        this.framelessTypeBuilders.put(Character.TYPE, random -> Character.valueOf((char)(random.nextInt(1000) - 500)));
        this.framelessTypeBuilders.put(Long.TYPE, random -> (long)(random.nextInt(1000) - 500));
        this.framelessTypeBuilders.put(double[].class, random -> random.doubles(20L, -10.0, 10.0).toArray());
        this.framelessTypeBuilders.put(float[].class, random -> ReflectionBasedBuilder.nextFloatArray(random));
        this.framelessTypeBuilders.put(boolean[].class, random -> ReflectionBasedBuilder.nextBooleanArray(random));
        this.framelessTypeBuilders.put(int[].class, random -> random.ints(20L, -100, 100).toArray());
        this.framelessTypeBuilders.put(char[].class, random -> ReflectionBasedBuilder.nextCharArray(random));
        this.framelessTypeBuilders.put(long[].class, random -> random.longs(20L, -100L, 100L).toArray());
        this.framelessTypeBuilders.put(DMatrix.class, random -> EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)20, (int)20));
    }

    public void registerFrameTypeBuilder(RandomFrameTypeBuilder frameTypeBuilder) {
        this.frameTypeBuilders.put(frameTypeBuilder.newInstance(new Random(), ReferenceFrame.getWorldFrame()).getClass(), frameTypeBuilder);
    }

    public void registerFramelessTypeBuilder(RandomFramelessTypeBuilder framelessTypeBuilder) {
        this.framelessTypeBuilders.put(framelessTypeBuilder.newInstance(new Random()).getClass(), framelessTypeBuilder);
    }

    public void registerRandomGeneratorClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerRandomGeneratorsFromClass(clazz);
        }
    }

    private void registerRandomGeneratorsFromClass(Class<?> classDeclaringRandomGenerators) {
        List frameTypeRandomGenerators = Stream.of(classDeclaringRandomGenerators.getMethods()).filter(method -> this.isFrameRandomGenerator((Method)method)).collect(Collectors.toList());
        for (Method generator : frameTypeRandomGenerators) {
            if (generator.getReturnType() == null || generator.getReturnType() == Void.TYPE) continue;
            this.frameTypeBuilders.put(generator.getReturnType(), (random, frame) -> {
                try {
                    return (ReferenceFrameHolder)generator.invoke(null, random, frame);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        List framelessTypeGenerators = Stream.of(classDeclaringRandomGenerators.getMethods()).filter(method -> this.isFramelessRandomGenerator((Method)method)).collect(Collectors.toList());
        for (Method generator : framelessTypeGenerators) {
            this.framelessTypeBuilders.put(generator.getReturnType(), random -> {
                try {
                    return generator.invoke(null, random);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private boolean isFramelessRandomGenerator(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0] == Random.class;
    }

    private boolean isFrameRandomGenerator(Method method) {
        if (method.getParameterCount() != 2) {
            return false;
        }
        if (method.getParameterTypes()[0] != Random.class || method.getParameterTypes()[1] != ReferenceFrame.class) {
            return false;
        }
        return ReferenceFrameHolder.class.isAssignableFrom(method.getReturnType());
    }

    Object next(Random random, ReferenceFrame frame, Class<?> type) {
        if (Object.class.equals(type)) {
            return null;
        }
        if (Collection.class.equals(type)) {
            return null;
        }
        Object object = this.nextFrameType(random, type, frame);
        if (object != null) {
            return object;
        }
        object = this.nextFramelessType(random, type);
        if (object != null) {
            return object;
        }
        throw new IllegalStateException("Unknown class: " + type.getSimpleName() + "\nThis class can be handled simply by registering a class that declares random generator as method with the following signature:\n\t" + type.getSimpleName() + " generatorNameDoesNotMatter(Random)\nor:\n\t" + type.getSimpleName() + " generatorNameDoesNotMatter(Random, ReferenceFrame) if the type is a frame type.\nNote that the return type can be any sub-class of " + type.getSimpleName() + "\nThe class declaring the generator is to be registered using " + ReflectionBasedBuilder.class.getSimpleName() + ".registerRandomGeneratorClasses(Class<?>...).");
    }

    Object[] next(Random random, ReferenceFrame frame, Class<?>[] types) {
        Object[] instances = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (type.isArray() && !type.getComponentType().isPrimitive()) {
                Class<?> componentType = type.getComponentType();
                Object[] array = (Object[])Array.newInstance(componentType, random.nextInt(15));
                for (int j = 0; j < array.length; ++j) {
                    array[j] = this.next(random, frame, componentType);
                    if (array[j] != null) continue;
                    return null;
                }
                instances[i] = array;
                continue;
            }
            instances[i] = this.next(random, frame, type);
            if (instances[i] != null) continue;
            return null;
        }
        return instances;
    }

    Object[] clone(Object[] parametersToClone) {
        Object[] clone = (Object[])Array.newInstance(parametersToClone.getClass().getComponentType(), parametersToClone.length);
        for (int i = 0; i < parametersToClone.length; ++i) {
            Object[] arrayToClone;
            Class<?> parameterType = parametersToClone[i].getClass();
            if (ReferenceFrame.class.isAssignableFrom(parameterType)) {
                clone[i] = parametersToClone[i];
                continue;
            }
            if (parameterType.isPrimitive() || parametersToClone[i] instanceof Number || parametersToClone[i] instanceof Boolean) {
                clone[i] = parametersToClone[i];
                continue;
            }
            if (DMatrix.class.isAssignableFrom(parameterType)) {
                clone[i] = new DMatrixRMaj((DMatrix)parametersToClone[i]);
                continue;
            }
            if (float[].class.equals(parameterType)) {
                arrayToClone = (float[])parametersToClone[i];
                clone[i] = new float[arrayToClone.length];
                System.arraycopy(arrayToClone, 0, clone[i], 0, arrayToClone.length);
                continue;
            }
            if (double[].class.equals(parameterType)) {
                arrayToClone = (double[])parametersToClone[i];
                clone[i] = new double[arrayToClone.length];
                System.arraycopy(arrayToClone, 0, clone[i], 0, arrayToClone.length);
                continue;
            }
            if (int[].class.equals(parameterType)) {
                arrayToClone = (int[])parametersToClone[i];
                clone[i] = new int[arrayToClone.length];
                System.arraycopy(arrayToClone, 0, clone[i], 0, arrayToClone.length);
                continue;
            }
            if (parameterType.isArray()) {
                clone[i] = this.clone((Object[])parametersToClone[i]);
                continue;
            }
            if (parameterType.isAnonymousClass()) {
                clone[i] = parametersToClone[i];
                continue;
            }
            try {
                ReferenceFrame frame = ReferenceFrame.getWorldFrame();
                if (parametersToClone[i] instanceof ReferenceFrameHolder) {
                    frame = ((ReferenceFrameHolder)parametersToClone[i]).getReferenceFrame();
                }
                clone[i] = this.next(new Random(), frame, parameterType);
                Method setter = parameterType.getMethod("set", parameterType);
                setter.invoke(clone[i], parametersToClone[i]);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                System.err.println("Unhandled type: " + parameterType.getSimpleName());
                return null;
            }
            catch (InvocationTargetException e) {
                System.err.println("Unhandled type: " + parameterType.getSimpleName());
                e.getTargetException().printStackTrace();
                return null;
            }
        }
        return clone;
    }

    private Object nextFramelessType(Random random, Class<?> type) {
        List matchingBuilders = this.framelessTypeBuilders.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (matchingBuilders.isEmpty()) {
            return null;
        }
        return ((RandomFramelessTypeBuilder)matchingBuilders.get(random.nextInt(matchingBuilders.size()))).newInstance(random);
    }

    private Object nextFrameType(Random random, Class<?> type, ReferenceFrame referenceFrame) {
        List matchingBuilders = this.frameTypeBuilders.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (matchingBuilders.isEmpty()) {
            return null;
        }
        return ((RandomFrameTypeBuilder)matchingBuilders.get(random.nextInt(matchingBuilders.size()))).newInstance(random, referenceFrame);
    }

    private static float[] nextFloatArray(Random random) {
        float[] next = new float[20];
        for (int i = 0; i < next.length; ++i) {
            next[i] = random.nextFloat();
        }
        return next;
    }

    private static boolean[] nextBooleanArray(Random random) {
        boolean[] next = new boolean[20];
        for (int i = 0; i < next.length; ++i) {
            next[i] = random.nextBoolean();
        }
        return next;
    }

    private static char[] nextCharArray(Random random) {
        char[] next = new char[20];
        for (int i = 0; i < next.length; ++i) {
            next[i] = (char)random.nextInt();
        }
        return next;
    }
}

