/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface FramePose3DReadOnly
extends Pose3DReadOnly,
ReferenceFrameHolder {
    public FramePoint3DReadOnly getPosition();

    public FrameQuaternionReadOnly getOrientation();

    default public void get(FixedFrameTuple3DBasics positionToPack, FixedFrameOrientation3DBasics orientationToPack) {
        positionToPack.set(this.getPosition());
        orientationToPack.set(this.getOrientation());
    }

    default public void get(FrameTuple3DBasics positionToPack, FrameOrientation3DBasics orientationToPack) {
        positionToPack.setIncludingFrame(this.getPosition());
        orientationToPack.setIncludingFrame(this.getOrientation());
    }

    default public void get(FixedFrameTuple3DBasics positionToPack, Orientation3DBasics orientationToPack) {
        positionToPack.set(this.getPosition());
        orientationToPack.set((Orientation3DReadOnly)this.getOrientation());
    }

    default public void get(FrameTuple3DBasics positionToPack, Orientation3DBasics orientationToPack) {
        positionToPack.setIncludingFrame(this.getPosition());
        orientationToPack.set((Orientation3DReadOnly)this.getOrientation());
    }

    default public void get(Tuple3DBasics positionToPack, FixedFrameOrientation3DBasics orientationToPack) {
        positionToPack.set((Tuple3DReadOnly)this.getPosition());
        orientationToPack.set(this.getOrientation());
    }

    default public void get(Tuple3DBasics positionToPack, FrameOrientation3DBasics orientationToPack) {
        positionToPack.set((Tuple3DReadOnly)this.getPosition());
        orientationToPack.setIncludingFrame(this.getOrientation());
    }

    default public void getRotationVector(FixedFrameVector3DBasics rotationVectorToPack) {
        this.getOrientation().getRotationVector(rotationVectorToPack);
    }

    default public void getRotationVector(FrameVector3DBasics rotationVectorToPack) {
        this.getOrientation().getRotationVector(rotationVectorToPack);
    }

    default public double getPositionDistance(FramePoint3DReadOnly point) {
        return this.getPosition().distance(point);
    }

    default public double getPositionDistance(FramePose3DReadOnly other) {
        return this.getPositionDistance(other.getPosition());
    }

    default public double getOrientationDistance(FrameQuaternionReadOnly orientation) {
        return this.getOrientation().distance(orientation);
    }

    default public double getOrientationDistance(FramePose3DReadOnly other) {
        return this.getOrientationDistance(other.getOrientation());
    }

    default public boolean epsilonEquals(FramePose3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Pose3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FramePose3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Pose3DReadOnly)other, epsilon);
    }

    default public boolean equals(FramePose3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.equals((Pose3DReadOnly)other);
    }
}

