/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface FrameLineSegment3DReadOnly
extends LineSegment3DReadOnly,
ReferenceFrameHolder {
    public FramePoint3DReadOnly getFirstEndpoint();

    public FramePoint3DReadOnly getSecondEndpoint();

    default public void get(FixedFramePoint3DBasics firstEndpointToPack, Point3DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(firstEndpointToPack);
        super.get((Point3DBasics)firstEndpointToPack, secondEndpointToPack);
    }

    default public void get(FramePoint3DBasics firstEndpointToPack, Point3DBasics secondEndpointToPack) {
        firstEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point3DBasics)firstEndpointToPack, secondEndpointToPack);
    }

    default public void get(Point3DBasics firstEndpointToPack, FixedFramePoint3DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(secondEndpointToPack);
        super.get(firstEndpointToPack, (Point3DBasics)secondEndpointToPack);
    }

    default public void get(Point3DBasics firstEndpointToPack, FramePoint3DBasics secondEndpointToPack) {
        secondEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get(firstEndpointToPack, (Point3DBasics)secondEndpointToPack);
    }

    default public void get(FixedFramePoint3DBasics firstEndpointToPack, FixedFramePoint3DBasics secondEndpointToPack) {
        this.checkReferenceFrameMatch(firstEndpointToPack, secondEndpointToPack);
        super.get((Point3DBasics)firstEndpointToPack, (Point3DBasics)secondEndpointToPack);
    }

    default public void get(FramePoint3DBasics firstEndpointToPack, FramePoint3DBasics secondEndpointToPack) {
        firstEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        secondEndpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point3DBasics)firstEndpointToPack, (Point3DBasics)secondEndpointToPack);
    }

    default public FrameVector3DBasics getDirection(boolean normalize) {
        return new FrameVector3D(this.getReferenceFrame(), (Tuple3DReadOnly)super.getDirection(normalize));
    }

    default public void getDirection(boolean normalize, FixedFrameVector3DBasics directionToPack) {
        this.checkReferenceFrameMatch(directionToPack);
        super.getDirection(normalize, (Vector3DBasics)directionToPack);
    }

    default public void getDirection(boolean normalize, FrameVector3DBasics directionToPack) {
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.getDirection(normalize, (Vector3DBasics)directionToPack);
    }

    default public double distanceSquared(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distanceSquared((Point3DReadOnly)point);
    }

    default public double distance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distance((Point3DReadOnly)point);
    }

    default public double distance(FrameLineSegment3DReadOnly frameLineSegment3DReadOnly) {
        this.checkReferenceFrameMatch(frameLineSegment3DReadOnly);
        return super.distance((LineSegment3DReadOnly)frameLineSegment3DReadOnly);
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        Point3DBasics projection = super.orthogonalProjectionCopy(pointToProject);
        if (projection == null) {
            return null;
        }
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)projection);
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(FramePoint3DReadOnly pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        Point3DBasics projection = super.orthogonalProjectionCopy((Point3DReadOnly)pointToProject);
        if (projection == null) {
            return null;
        }
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)projection);
    }

    default public boolean orthogonalProjection(FixedFramePoint3DBasics pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point3DBasics)pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(projectionToPack);
        return super.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject, projectionToPack);
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean isBetweenEndpoints(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isBetweenEndpoints((Point3DReadOnly)point);
    }

    default public boolean isBetweenEndpoints(FramePoint3DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isBetweenEndpoints((Point3DReadOnly)point, epsilon);
    }

    default public double percentageAlongLineSegment(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.percentageAlongLineSegment((Point3DReadOnly)point);
    }

    default public FramePoint3DBasics pointBetweenEndpointsGivenPercentage(double percentage) {
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)super.pointBetweenEndpointsGivenPercentage(percentage));
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, FixedFramePoint3DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointBetweenEndpointsGivenPercentage(percentage, (Point3DBasics)pointToPack);
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, FramePoint3DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointBetweenEndpointsGivenPercentage(percentage, (Point3DBasics)pointToPack);
    }

    default public FramePoint3DBasics pointOnLineGivenPercentage(double percentage) {
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)super.pointOnLineGivenPercentage(percentage));
    }

    default public void pointOnLineGivenPercentage(double percentage, FixedFramePoint3DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointOnLineGivenPercentage(percentage, (Point3DBasics)pointToPack);
    }

    default public void pointOnLineGivenPercentage(double percentage, FramePoint3DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointOnLineGivenPercentage(percentage, (Point3DBasics)pointToPack);
    }

    default public double dotProduct(FrameLineSegment3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.dotProduct((LineSegment3DReadOnly)other);
    }

    default public FramePoint3DBasics midpoint() {
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)super.midpoint());
    }

    default public void midpoint(FixedFramePoint3DBasics midpointToPack) {
        this.checkReferenceFrameMatch(midpointToPack);
        super.midpoint((Point3DBasics)midpointToPack);
    }

    default public void midpoint(FramePoint3DBasics midpointToPack) {
        midpointToPack.setReferenceFrame(this.getReferenceFrame());
        super.midpoint((Point3DBasics)midpointToPack);
    }

    default public boolean epsilonEquals(FrameLineSegment3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((LineSegment3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameLineSegment3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((LineSegment3DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameLineSegment3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.equals((LineSegment3DReadOnly)other);
    }
}

