/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface FixedFramePose3DBasics
extends FramePose3DReadOnly,
Pose3DBasics {
    @Override
    public FixedFramePoint3DBasics getPosition();

    @Override
    public FixedFrameQuaternionBasics getOrientation();

    default public void setFromReferenceFrame(ReferenceFrame referenceFrame) {
        this.setToZero();
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    @Deprecated
    default public void setPosition(FrameTuple2DReadOnly position) {
        this.getPosition().set(position);
    }

    @Deprecated
    default public void setPosition(FrameTuple2DReadOnly position, double z) {
        this.getPosition().set(position, z);
    }

    @Deprecated
    default public void setPosition(FrameTuple3DReadOnly position) {
        this.getPosition().set(position);
    }

    @Deprecated
    default public void setOrientation(FrameOrientation2DReadOnly orientation) {
        this.getOrientation().set(orientation);
    }

    @Deprecated
    default public void setOrientation(FrameOrientation3DReadOnly orientation) {
        this.getOrientation().set(orientation);
    }

    default public void set(ReferenceFrame referenceFrame, Pose2DReadOnly pose2DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose2DReadOnly);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose3DReadOnly);
    }

    default public void set(FramePose2DReadOnly framePose2DReadOnly) {
        this.checkReferenceFrameMatch(framePose2DReadOnly);
        super.set((Pose2DReadOnly)framePose2DReadOnly);
    }

    default public void set(FramePose3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.set((Pose3DReadOnly)other);
    }

    default public void setMatchingFrame(FramePose3DReadOnly other) {
        super.set((Pose3DReadOnly)other);
        other.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void set(FrameTuple3DReadOnly position, Orientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(position);
        super.set((Tuple3DReadOnly)position, orientation);
    }

    default public void set(Tuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.set(position, (Orientation3DReadOnly)orientation);
    }

    default public void set(FrameTuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(position, orientation);
        super.set((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
    }

    default public void prependTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch(translation);
        super.prependTranslation((Tuple3DReadOnly)translation);
    }

    default public void prependRotation(FrameOrientation3DReadOnly rotation) {
        this.checkReferenceFrameMatch(rotation);
        super.prependRotation((Orientation3DReadOnly)rotation);
    }

    default public void appendTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch(translation);
        super.appendTranslation((Tuple3DReadOnly)translation);
    }

    default public void appendRotation(FrameOrientation3DReadOnly rotation) {
        this.checkReferenceFrameMatch(rotation);
        super.appendRotation((Orientation3DReadOnly)rotation);
    }

    default public void interpolate(FramePose3DReadOnly other, double alpha) {
        this.checkReferenceFrameMatch(other);
        super.interpolate((Pose3DReadOnly)other, alpha);
    }

    default public void interpolate(FramePose3DReadOnly pose1, Pose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose1);
        super.interpolate((Pose3DReadOnly)pose1, pose2, alpha);
    }

    default public void interpolate(Pose3DReadOnly pose1, FramePose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose2);
        super.interpolate(pose1, (Pose3DReadOnly)pose2, alpha);
    }

    default public void interpolate(FramePose3DReadOnly pose1, FramePose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch(pose1, pose2);
        super.interpolate((Pose3DReadOnly)pose1, (Pose3DReadOnly)pose2, alpha);
    }
}

