/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import org.ejml.ops.MatrixFeatures_D;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.tools.EuclidCoreTools;

class ReflectionBasedComparer {
    private static final String EPSILON_EQUALS = "epsilonEquals";
    private static final Predicate<Method> epsilonEqualsMethodFilter = m -> {
        if (!m.getName().equals(EPSILON_EQUALS) || m.getParameterCount() != 2) {
            return false;
        }
        return m.getParameterTypes()[1] == Double.TYPE || m.getParameterTypes()[1] == Float.TYPE;
    };

    ReflectionBasedComparer() {
    }

    static <T> boolean epsilonEquals(Object framelessParameter, Object frameParameter, double epsilon) {
        Method epsilonEqualsMethod;
        if (framelessParameter == null && frameParameter == null) {
            return true;
        }
        if (framelessParameter != null ^ frameParameter != null) {
            return false;
        }
        if (framelessParameter instanceof Clearable && frameParameter instanceof Clearable && ((Clearable)framelessParameter).containsNaN() && ((Clearable)frameParameter).containsNaN()) {
            return true;
        }
        List epsilonEqualsMethods = Stream.of(frameParameter.getClass().getMethods()).filter(epsilonEqualsMethodFilter).collect(Collectors.toList());
        if (!epsilonEqualsMethods.isEmpty() && (epsilonEqualsMethod = (Method)epsilonEqualsMethods.stream().filter(m -> m.getParameterTypes()[0] != Object.class).filter(m -> m.getParameterTypes()[0].isAssignableFrom(framelessParameter.getClass())).findAny().orElse(null)) != null) {
            try {
                boolean epsilonEqualsResult = (Boolean)epsilonEqualsMethod.invoke(frameParameter, framelessParameter, epsilon);
                return epsilonEqualsResult;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                System.err.println("Something went wrong when invoking the epsilonEquals method for " + frameParameter.getClass().getSimpleName());
                System.err.println("Objects used as parameters: " + MethodSignature.getMethodSimpleName(Boolean.TYPE, EPSILON_EQUALS, framelessParameter.getClass(), Double.TYPE));
                e.printStackTrace();
                throw new AssertionError((Object)e);
            }
        }
        if (Double.TYPE.isInstance(framelessParameter) || Float.TYPE.isInstance(framelessParameter)) {
            if (!Double.TYPE.isInstance(frameParameter) && !Float.TYPE.isInstance(frameParameter)) {
                throw new RuntimeException("Reached unexpected state.");
            }
            return EuclidCoreTools.epsilonEquals((double)((Double)framelessParameter), (double)((Double)frameParameter), (double)epsilon);
        }
        if (Integer.TYPE.isInstance(framelessParameter) || Long.TYPE.isInstance(framelessParameter)) {
            if (!Integer.TYPE.isInstance(frameParameter) && !Long.TYPE.isInstance(frameParameter)) {
                throw new RuntimeException("Reached unexpected state.");
            }
            return ((Long)framelessParameter).longValue() == ((Long)frameParameter).longValue();
        }
        if (Double.class.isInstance(framelessParameter) || Float.class.isInstance(framelessParameter)) {
            double frameDouble;
            if (!Double.class.isInstance(frameParameter) && !Float.class.isInstance(frameParameter)) {
                throw new RuntimeException("Reached unexpected state.");
            }
            double framelessDouble = ((Number)framelessParameter).doubleValue();
            return Double.compare(framelessDouble, frameDouble = ((Number)frameParameter).doubleValue()) == 0 || EuclidCoreTools.epsilonEquals((double)framelessDouble, (double)frameDouble, (double)epsilon);
        }
        if (Integer.class.isInstance(framelessParameter) || Long.class.isInstance(framelessParameter)) {
            if (!Integer.class.isInstance(frameParameter) && !Long.class.isInstance(frameParameter)) {
                throw new RuntimeException("Reached unexpected state.");
            }
            return ((Number)framelessParameter).longValue() == ((Number)frameParameter).longValue();
        }
        if (Boolean.class.isInstance(framelessParameter)) {
            if (!Boolean.class.isInstance(frameParameter)) {
                throw new RuntimeException("Reached unexpected state.");
            }
            return ((Boolean)framelessParameter).booleanValue() == ((Boolean)frameParameter).booleanValue();
        }
        if (framelessParameter instanceof List) {
            if (frameParameter instanceof List) {
                List framelessList = (List)framelessParameter;
                List frameList = (List)frameParameter;
                if (framelessList.size() != frameList.size()) {
                    return false;
                }
                for (int i = 0; i < framelessList.size(); ++i) {
                    if (ReflectionBasedComparer.epsilonEquals(framelessList.get(i), frameList.get(i), epsilon)) continue;
                    return false;
                }
                return true;
            }
            throw new RuntimeException("Reached unexpected state.");
        }
        if (framelessParameter instanceof DMatrix && frameParameter instanceof DMatrix) {
            return MatrixFeatures_D.isIdentical((DMatrix)((DMatrix)framelessParameter), (DMatrix)((DMatrix)frameParameter), (double)epsilon);
        }
        if (framelessParameter.getClass().isArray() && frameParameter.getClass().isArray()) {
            return ReflectionBasedComparer.arrayEquals(framelessParameter, frameParameter, epsilon);
        }
        if (framelessParameter instanceof String && frameParameter instanceof String) {
            return true;
        }
        if (framelessParameter instanceof Class && frameParameter instanceof Class) {
            return true;
        }
        throw new RuntimeException("Did not expect the following types: " + framelessParameter.getClass().getSimpleName() + " & " + frameParameter.getClass().getSimpleName());
    }

    private static boolean arrayEquals(Object framelessParameter, Object frameParameter, double epsilon) {
        if (framelessParameter.getClass().getComponentType().isPrimitive()) {
            if (framelessParameter instanceof int[] && frameParameter instanceof int[]) {
                int[] framelessArray = (int[])framelessParameter;
                int[] frameArray = (int[])frameParameter;
                if (framelessArray.length != frameArray.length) {
                    return false;
                }
                for (int i = 0; i < framelessArray.length; ++i) {
                    if (Float.compare(framelessArray[i], frameArray[i]) == 0 || EuclidCoreTools.epsilonEquals((double)framelessArray[i], (double)frameArray[i], (double)epsilon)) continue;
                    return false;
                }
                return true;
            }
            if (framelessParameter instanceof float[] && frameParameter instanceof float[]) {
                float[] framelessArray = (float[])framelessParameter;
                float[] frameArray = (float[])frameParameter;
                if (framelessArray.length != frameArray.length) {
                    return false;
                }
                for (int i = 0; i < framelessArray.length; ++i) {
                    if (Float.compare(framelessArray[i], frameArray[i]) == 0 || EuclidCoreTools.epsilonEquals((double)framelessArray[i], (double)frameArray[i], (double)epsilon)) continue;
                    return false;
                }
                return true;
            }
            if (framelessParameter instanceof double[] && frameParameter instanceof double[]) {
                double[] framelessArray = (double[])framelessParameter;
                double[] frameArray = (double[])frameParameter;
                if (framelessArray.length != frameArray.length) {
                    return false;
                }
                for (int i = 0; i < framelessArray.length; ++i) {
                    if (Double.compare(framelessArray[i], frameArray[i]) == 0 || EuclidCoreTools.epsilonEquals((double)framelessArray[i], (double)frameArray[i], (double)epsilon)) continue;
                    return false;
                }
                return true;
            }
            throw new RuntimeException("Did not expect the following component types: " + framelessParameter.getClass().getComponentType().getSimpleName() + " & " + frameParameter.getClass().getComponentType().getSimpleName());
        }
        Object[] framelessArray = (Object[])framelessParameter;
        Object[] frameArray = (Object[])frameParameter;
        if (framelessArray.length != frameArray.length) {
            return false;
        }
        for (int i = 0; i < framelessArray.length; ++i) {
            if (ReflectionBasedComparer.epsilonEquals(framelessArray[i], frameArray[i], epsilon)) continue;
            return false;
        }
        return true;
    }
}

