/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector4DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class FrameVector4D
implements FrameVector4DBasics,
GeometryObject<FrameVector4D> {
    private ReferenceFrame referenceFrame;
    private final Vector4D vector = new Vector4D();

    public FrameVector4D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameVector4D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameVector4D(ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        this.setIncludingFrame(referenceFrame, x, y, z, s);
    }

    public FrameVector4D(ReferenceFrame referenceFrame, double[] vectorArray) {
        this.setIncludingFrame(referenceFrame, vectorArray);
    }

    public FrameVector4D(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple4DReadOnly);
    }

    public FrameVector4D(FrameTuple4DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameVector4D other) {
        FrameVector4DBasics.super.set((FrameTuple4DReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.vector.setX(x);
    }

    public void setY(double y) {
        this.vector.setY(y);
    }

    public void setZ(double z) {
        this.vector.setZ(z);
    }

    public void setS(double s) {
        this.vector.setS(s);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.vector.getX();
    }

    public double getY() {
        return this.vector.getY();
    }

    public double getZ() {
        return this.vector.getZ();
    }

    public double getS() {
        return this.vector.getS();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple4DReadOnly) {
            return this.equals((FrameTuple4DReadOnly)object);
        }
        return false;
    }

    public boolean epsilonEquals(FrameVector4D other, double epsilon) {
        return FrameVector4DBasics.super.epsilonEquals((FrameTuple4DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameVector4D other, double epsilon) {
        return FrameVector4DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameTuple4DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.vector, (Object)this.referenceFrame);
    }
}

