/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.GeometricallyComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class FrameBoundingBox3D
implements FrameBoundingBox3DBasics,
EpsilonComparable<FrameBoundingBox3D>,
Settable<FrameBoundingBox3D>,
GeometricallyComparable<FrameBoundingBox3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics minPoint = EuclidFrameFactories.newFixedFramePoint3DBasics(this);
    private final FixedFramePoint3DBasics maxPoint = EuclidFrameFactories.newFixedFramePoint3DBasics(this);

    public FrameBoundingBox3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameBoundingBox3D(ReferenceFrame referenceFrame) {
        this.setToNaN(referenceFrame);
    }

    public FrameBoundingBox3D(ReferenceFrame referenceFrame, Point3DReadOnly min, Point3DReadOnly max) {
        this.setIncludingFrame(referenceFrame, min, max);
    }

    public FrameBoundingBox3D(FramePoint3DReadOnly min, FramePoint3DReadOnly max) {
        this.setIncludingFrame(min, max);
    }

    public FrameBoundingBox3D(ReferenceFrame referenceFrame, BoundingBox3DReadOnly boundingBox3DReadOnly) {
        this.setIncludingFrame(referenceFrame, boundingBox3DReadOnly);
    }

    public FrameBoundingBox3D(FrameBoundingBox3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameBoundingBox3D other) {
        FrameBoundingBox3DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getMinPoint() {
        return this.minPoint;
    }

    @Override
    public FixedFramePoint3DBasics getMaxPoint() {
        return this.maxPoint;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean epsilonEquals(FrameBoundingBox3D other, double epsilon) {
        return FrameBoundingBox3DBasics.super.epsilonEquals((FrameBoundingBox3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameBoundingBox3D other, double epsilon) {
        return FrameBoundingBox3DBasics.super.geometricallyEquals((FrameBoundingBox3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameBoundingBox3DReadOnly) {
            return FrameBoundingBox3DBasics.super.equals((FrameBoundingBox3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameBoundingBox3DString(this);
    }
}

