/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;

public interface FrameVertex3DSupplier
extends Vertex3DSupplier,
ReferenceFrameHolder {
    public static final FrameVertex3DSupplier EMPTY_SUPPLIER = new FrameVertex3DSupplier(){

        @Override
        public FramePoint3DReadOnly getVertex(int index) {
            return null;
        }

        public int getNumberOfVertices() {
            return 0;
        }
    };

    public FramePoint3DReadOnly getVertex(int var1);

    @Override
    default public ReferenceFrame getReferenceFrame() {
        return this.isEmpty() ? null : this.getVertex(0).getReferenceFrame();
    }

    default public boolean equals(FrameVertex3DSupplier other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).equals(other.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonEquals(FrameVertex3DSupplier other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).epsilonEquals(other.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static FrameVertex3DSupplier emptyFrameVertex3DSupplier() {
        return EMPTY_SUPPLIER;
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(FramePoint3DReadOnly ... vertices) {
        return FrameVertex3DSupplier.asFrameVertex3DSupplier(Arrays.asList(vertices));
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(FramePoint3DReadOnly[] vertices, int numberOfVertices) {
        return FrameVertex3DSupplier.asFrameVertex3DSupplier(Arrays.asList(vertices), numberOfVertices);
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(FramePoint3DReadOnly[] vertices, int startIndex, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return FrameVertex3DSupplier.emptyFrameVertex3DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return FrameVertex3DSupplier.asFrameVertex3DSupplier(Arrays.asList(vertices), startIndex, numberOfVertices);
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(List<? extends FramePoint3DReadOnly> vertices) {
        return FrameVertex3DSupplier.asFrameVertex3DSupplier(vertices, vertices.size());
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(List<? extends FramePoint3DReadOnly> vertices, int numberOfVertices) {
        return FrameVertex3DSupplier.asFrameVertex3DSupplier(vertices, 0, numberOfVertices);
    }

    public static FrameVertex3DSupplier asFrameVertex3DSupplier(final List<? extends FramePoint3DReadOnly> vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return FrameVertex3DSupplier.emptyFrameVertex3DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.size()) {
            throw new IllegalArgumentException("The list is too small. List size = " + vertices.size() + ", expected minimum size = " + (startIndex + numberOfVertices));
        }
        return new FrameVertex3DSupplier(){

            @Override
            public FramePoint3DReadOnly getVertex(int index) {
                return (FramePoint3DReadOnly)vertices.get(index + startIndex);
            }

            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public String toString() {
                return "Vertex 3D Supplier: " + vertices.subList(startIndex, startIndex + numberOfVertices).toString();
            }
        };
    }
}

