/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FixedFrameRamp3DBasics
extends Ramp3DBasics,
FrameRamp3DReadOnly,
FixedFrameShape3DBasics {
    public FixedFrameVector3DBasics getSize();

    @Override
    public FixedFrameShape3DPoseBasics getPose();

    default public FixedFrameRotationMatrixBasics getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public FixedFramePoint3DBasics getPosition() {
        return this.getPose().getShapePosition();
    }

    default public void set(ReferenceFrame referenceFrame, Ramp3DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    default public void set(FrameRamp3DReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(position, orientation, sizeX, sizeY, sizeZ);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(position, orientation, size);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, sizeX, sizeY, sizeZ);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, size);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation, (ReferenceFrameHolder)size);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)size);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, sizeX, sizeY, sizeZ);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, size);
    }

    default public void set(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, sizeX, sizeY, sizeZ);
    }

    default public void set(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, size);
    }

    default public void set(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)size);
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, (Vector3DReadOnly)size);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, sizeX, sizeY, sizeZ);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, size);
    }

    default public void set(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, sizeX, sizeY, sizeZ);
    }

    default public void set(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, size);
    }

    default public void set(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)size);
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, (Vector3DReadOnly)size);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double[] size) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, size);
    }

    default public void set(FrameShape3DPoseReadOnly pose, double[] size) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, size);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Ramp3DReadOnly other) {
        this.set(other);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameRamp3DReadOnly other) {
        this.setMatchingFrame(other.getReferenceFrame(), other);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.set(position, orientation, sizeX, sizeY, sizeZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.set(position, orientation, size);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, sizeX, sizeY, sizeZ);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, size);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation, (ReferenceFrameHolder)size);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)size);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, sizeX, sizeY, sizeZ);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, size);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)size);
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, (Vector3DReadOnly)size);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, sizeX, sizeY, sizeZ);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, size);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)size);
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, (Vector3DReadOnly)size);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double[] size) {
        this.set(pose, size);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, double[] size) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, size);
    }
}

