/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FixedFrameShape3DPoseBasics
extends Shape3DPoseBasics,
FrameShape3DPoseReadOnly {
    public FixedFrameRotationMatrixBasics getShapeOrientation();

    public FixedFramePoint3DBasics getShapePosition();

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose);
    }

    default public void set(FramePose3DReadOnly pose) {
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose);
    }

    default public void set(FrameShape3DPoseReadOnly pose) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose);
    }

    default public void set(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(orientation, translation);
    }

    default public void set(FrameOrientation3DReadOnly orientation, FrameTuple3DReadOnly translation) {
        orientation.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.set(orientation.getReferenceFrame(), (Orientation3DReadOnly)orientation, (Tuple3DReadOnly)translation);
    }

    default public void set(ReferenceFrame referenceFrame, RotationMatrixReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(rotationMatrix, translation);
    }

    default public void set(FrameRotationMatrixReadOnly rotationMatrix, FrameTuple3DReadOnly translation) {
        rotationMatrix.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.set(rotationMatrix.getReferenceFrame(), (RotationMatrixReadOnly)rotationMatrix, (Tuple3DReadOnly)translation);
    }

    default public void setAndInvert(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.setAndInvert((RigidBodyTransformReadOnly)other);
    }

    default public void setRotationAndZeroTranslation(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        super.setRotationAndZeroTranslation((Orientation3DReadOnly)orientation);
    }

    default public void setRotationAndZeroTranslation(FrameRotationMatrixReadOnly rotationMatrix) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rotationMatrix);
        super.setRotationAndZeroTranslation((RotationMatrixReadOnly)rotationMatrix);
    }

    default public void setRotationAndZeroTranslation(FrameVector3DReadOnly rotationVector) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rotationVector);
        super.setRotationAndZeroTranslation((Vector3DReadOnly)rotationVector);
    }

    default public void setRotationEulerAndZeroTranslation(FrameVector3DReadOnly eulerAngles) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)eulerAngles);
        super.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
    }

    default public void setTranslationAndIdentityRotation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        super.setTranslationAndIdentityRotation((Tuple3DReadOnly)translation);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Pose3DReadOnly pose) {
        this.set(pose);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose) {
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose) {
        this.set(pose);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.set(orientation, translation);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameOrientation3DReadOnly orientation, FrameTuple3DReadOnly translation) {
        orientation.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.setMatchingFrame(orientation.getReferenceFrame(), (Orientation3DReadOnly)orientation, (Tuple3DReadOnly)translation);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RotationMatrixReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.set(rotationMatrix, translation);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameRotationMatrixReadOnly rotationMatrix, FrameTuple3DReadOnly translation) {
        rotationMatrix.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.setMatchingFrame(rotationMatrix.getReferenceFrame(), (RotationMatrixReadOnly)rotationMatrix, (Tuple3DReadOnly)translation);
    }

    default public void appendTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        super.appendTranslation((Tuple3DReadOnly)translation);
    }

    default public void appendOrientation(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.getRotation().append((Orientation3DReadOnly)orientation);
    }

    default public void prependTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        super.prependTranslation((Tuple3DReadOnly)translation);
    }

    default public void prependOrientation(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        super.prependOrientation((Orientation3DReadOnly)orientation);
    }

    default public void multiply(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.multiply((RigidBodyTransformReadOnly)other);
    }

    default public void multiplyInvertThis(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.multiplyInvertThis((RigidBodyTransformReadOnly)other);
    }

    default public void multiplyInvertOther(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.multiplyInvertOther((RigidBodyTransformReadOnly)other);
    }

    default public void preMultiply(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.preMultiply((RigidBodyTransformReadOnly)other);
    }

    default public void preMultiplyInvertThis(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.preMultiplyInvertThis((RigidBodyTransformReadOnly)other);
    }

    default public void preMultiplyInvertOther(FrameShape3DPoseReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        super.preMultiplyInvertOther((RigidBodyTransformReadOnly)other);
    }
}

