/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameEllipsoid3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FrameEllipsoid3DReadOnly
extends Ellipsoid3DReadOnly,
FrameShape3DReadOnly {
    public FrameVector3DReadOnly getRadii();

    @Override
    public FrameShape3DPoseReadOnly getPose();

    default public FrameRotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public FramePoint3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public FramePoint3DReadOnly getCentroid() {
        return this.getPosition();
    }

    default public int intersectionWith(FrameLine3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        FrameShape3DReadOnly.super.getBoundingBox(boundingBoxToPack);
    }

    @Override
    default public void getBoundingBox(ReferenceFrame destinationFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxEllipsoid3D(this, destinationFrame, boundingBoxToPack);
    }

    @Override
    public FixedFrameEllipsoid3DBasics copy();

    default public String toString(String format) {
        return EuclidFrameShapeIOTools.getFrameEllipsoid3DString(format, this);
    }
}

