/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameCapsule3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;

public interface FrameCapsule3DReadOnly
extends Capsule3DReadOnly,
FrameShape3DReadOnly {
    public FramePoint3DReadOnly getPosition();

    public FrameUnitVector3DReadOnly getAxis();

    @Override
    default public FramePoint3DReadOnly getCentroid() {
        return this.getPosition();
    }

    default public FramePoint3DReadOnly getTopCenter() {
        FramePoint3D topCenter = new FramePoint3D(this.getReferenceFrame());
        topCenter.scaleAdd(this.getHalfLength(), (FrameTuple3DReadOnly)this.getAxis(), (FrameTuple3DReadOnly)this.getPosition());
        return topCenter;
    }

    default public FramePoint3DReadOnly getBottomCenter() {
        FramePoint3D bottomCenter = new FramePoint3D(this.getReferenceFrame());
        bottomCenter.scaleAdd(-this.getHalfLength(), (FrameTuple3DReadOnly)this.getAxis(), (FrameTuple3DReadOnly)this.getPosition());
        return bottomCenter;
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        FrameShape3DReadOnly.super.getBoundingBox(boundingBoxToPack);
    }

    @Override
    default public void getBoundingBox(ReferenceFrame destinationFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxCapsule3D(this, destinationFrame, boundingBoxToPack);
    }

    @Override
    default public FrameShape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public FixedFrameCapsule3DBasics copy();

    default public String toString(String format) {
        return EuclidFrameShapeIOTools.getFrameCapsule3DString(format, this);
    }
}

