/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTorus3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTorus3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameTorus3D
implements FrameTorus3DBasics,
Settable<FrameTorus3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameUnitVector3DBasics axis = EuclidFrameFactories.newFixedFrameUnitVector3DBasics((ReferenceFrameHolder)this, (Vector3DReadOnly)Axis3D.Z);
    private double radius;
    private double tubeRadius;

    public FrameTorus3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameTorus3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 0.5);
    }

    public FrameTorus3D(ReferenceFrame referenceFrame, double radius, double tubeRadius) {
        this.setReferenceFrame(referenceFrame);
        this.setRadii(radius, tubeRadius);
    }

    public FrameTorus3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Vector3DReadOnly axis, double radius, double tubeRadius) {
        this.setIncludingFrame(referenceFrame, position, axis, radius, tubeRadius);
    }

    public FrameTorus3D(FramePoint3DReadOnly position, FrameVector3DReadOnly axis, double radius, double tubeRadius) {
        this.setIncludingFrame(position, axis, radius, tubeRadius);
    }

    public FrameTorus3D(ReferenceFrame referenceFrame, Torus3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    public FrameTorus3D(FrameTorus3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setRadii(double radius, double tubeRadius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a " + this.getClass().getSimpleName() + " cannot be negative: " + radius);
        }
        if (tubeRadius < 0.0) {
            throw new IllegalArgumentException("The tube radius of a " + this.getClass().getSimpleName() + " cannot be negative: " + tubeRadius);
        }
        this.radius = radius;
        this.tubeRadius = tubeRadius;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getTubeRadius() {
        return this.tubeRadius;
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameUnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public FrameTorus3D copy() {
        return new FrameTorus3D(this);
    }

    public void set(FrameTorus3D other) {
        FrameTorus3DBasics.super.set(other);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTorus3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.addToHashCode((long)hash, (double)this.radius);
        hash = EuclidHashCodeTools.addToHashCode((long)hash, (double)this.tubeRadius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.position.hashCode());
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.axis.hashCode());
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

