/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class EuclidFrameShapeTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidFrameShapeTestTools() {
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.epsilonEquals((EuclidGeometry)actual, epsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                Object difference = "[";
                difference = (String)difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = (String)difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.norm();
                difference = (String)difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.norm();
                difference = (String)difference + "]";
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)difference, (String)format);
            }
        }
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(null, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, epsilon, epsilon, format);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.geometricallyEquals(actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                Object difference = "[";
                difference = (String)difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = (String)difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.norm();
                difference = (String)difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.norm();
                difference = (String)difference + "]";
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)difference, (String)format);
            }
        }
    }
}

