/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.gjk;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class SupportingVertexTransformer
implements SupportingVertexHolder {
    private final Vector3D localSupportDirection = new Vector3D();
    private SupportingVertexHolder original;
    private RigidBodyTransformReadOnly transform;

    public void initialize(SupportingVertexHolder original, RigidBodyTransformReadOnly transform) {
        this.original = original;
        this.transform = transform;
    }

    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        this.transform.inverseTransform(supportDirection, (Vector3DBasics)this.localSupportDirection);
        boolean success = this.original.getSupportingVertex((Vector3DReadOnly)this.localSupportDirection, supportingVertexToPack);
        if (success) {
            this.transform.transform(supportingVertexToPack);
        }
        return success;
    }

    public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SupportingVertexTransformer)) {
            return false;
        }
        SupportingVertexTransformer other = (SupportingVertexTransformer)geometry;
        return this.original.equals((EuclidGeometry)other.original) && this.transform.equals((EuclidGeometry)other.transform);
    }

    public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SupportingVertexTransformer)) {
            return false;
        }
        SupportingVertexTransformer other = (SupportingVertexTransformer)geometry;
        return this.original.epsilonEquals((EuclidGeometry)other.original, epsilon) && this.transform.epsilonEquals((EuclidGeometry)other.transform, epsilon);
    }

    public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SupportingVertexTransformer)) {
            return false;
        }
        SupportingVertexTransformer other = (SupportingVertexTransformer)geometry;
        return this.original.geometricallyEquals((EuclidGeometry)other.original, epsilon) && this.transform.geometricallyEquals((EuclidGeometry)other.transform, epsilon);
    }

    public String toString(String format) {
        return "Original: " + this.original.toString(format) + "\nTransform: " + this.transform.toString(format);
    }
}

