/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameCylinder3D
implements FrameCylinder3DBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameUnitVector3DBasics axis = EuclidFrameFactories.newFixedFrameUnitVector3DBasics((ReferenceFrameHolder)this, (Vector3DReadOnly)Axis3D.Z);
    private double radius;
    private double length;
    private double halfLength;
    private final FramePoint3DReadOnly topCenter = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)this, () -> this.halfLength * this.axis.getX() + this.position.getX(), () -> this.halfLength * this.axis.getY() + this.position.getY(), () -> this.halfLength * this.axis.getZ() + this.position.getZ());
    private final FramePoint3DReadOnly bottomCenter = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)this, () -> -this.halfLength * this.axis.getX() + this.position.getX(), () -> -this.halfLength * this.axis.getY() + this.position.getY(), () -> -this.halfLength * this.axis.getZ() + this.position.getZ());

    public FrameCylinder3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameCylinder3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 0.5);
    }

    public FrameCylinder3D(ReferenceFrame referenceFrame, double length, double radius) {
        this.setReferenceFrame(referenceFrame);
        this.setSize(length, radius);
    }

    public FrameCylinder3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        this.setIncludingFrame(referenceFrame, position, axis, length, radius);
    }

    public FrameCylinder3D(FramePoint3DReadOnly position, FrameVector3DReadOnly axis, double length, double radius) {
        this.setIncludingFrame(position, axis, length, radius);
    }

    public FrameCylinder3D(ReferenceFrame referenceFrame, Cylinder3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    public FrameCylinder3D(FrameCylinder3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Cylinder3D cannot be negative: " + radius);
        }
        this.radius = radius;
    }

    public void setLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("The length of a Cylinder3D cannot be negative: " + length);
        }
        this.length = length;
        this.halfLength = 0.5 * length;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getLength() {
        return this.length;
    }

    public double getHalfLength() {
        return this.halfLength;
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameUnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public FramePoint3DReadOnly getTopCenter() {
        return this.topCenter;
    }

    public FramePoint3DReadOnly getBottomCenter() {
        return this.bottomCenter;
    }

    @Override
    public FrameCylinder3D copy() {
        return new FrameCylinder3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameCylinder3DReadOnly) {
            return FrameCylinder3DBasics.super.equals((EuclidFrameGeometry)((FrameCylinder3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.toLongHashCode((double)this.length, (double)this.radius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((Object)this.position, (Object)this.axis));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

