/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FixedFrameShape3DPose;
import us.ihmc.euclid.referenceFrame.FrameRampPolytope3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRampPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameRamp3D
implements FrameRamp3DBasics,
GeometryObject<FrameRamp3D> {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private ReferenceFrame referenceFrame;
    private final FixedFrameShape3DPose pose = new FixedFrameShape3DPose(this);
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final FixedFrameVector3DBasics size = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((ReferenceFrameHolder)this, (axis, newValue) -> {
        this.checkSizePositive((Axis3D)axis);
        this.notifyChangeListeners();
    }, null);
    private boolean rampSurfaceNormalDirty = true;
    private final FixedFrameVector3DBasics rampSurfaceNormal = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((ReferenceFrameHolder)this, null, axis -> this.updateRampSurfaceNormal());
    private boolean rampFeaturesDirty = true;
    private double rampLength;
    private double angleOfRampIncline;
    private boolean centroidDirty = true;
    private final FixedFramePoint3DBasics centroid = EuclidFrameFactories.newObservableFixedFramePoint3DBasics((ReferenceFrameHolder)this, null, axis -> this.updateCentroid());
    private FrameRampPolytope3D polytopeView = null;

    public FrameRamp3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameRamp3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 1.0, 1.0);
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, double sizeX, double sizeY, double sizeZ) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Vector3DReadOnly size) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, position, orientation, size);
        this.setupListeners();
    }

    public FrameRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameRamp3D(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameRamp3D(ReferenceFrame referenceFrame, Ramp3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameRamp3D(FrameRamp3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.changeListeners.add(() -> {
            this.rampSurfaceNormalDirty = true;
            this.rampFeaturesDirty = true;
            this.centroidDirty = true;
        });
        this.pose.addChangeListeners(this.changeListeners);
    }

    private void updateRamp() {
        if (!this.rampFeaturesDirty) {
            return;
        }
        this.rampLength = EuclidShapeTools.computeRamp3DLength((double)this.size.getX(), (double)this.size.getZ());
        this.angleOfRampIncline = EuclidShapeTools.computeRamp3DIncline((double)this.size.getX(), (double)this.size.getZ());
        this.rampFeaturesDirty = false;
    }

    private void updateRampSurfaceNormal() {
        if (!this.rampSurfaceNormalDirty) {
            return;
        }
        this.rampSurfaceNormalDirty = false;
        this.rampSurfaceNormal.set(-this.getSizeZ() / this.getRampLength(), 0.0, this.getSizeX() / this.getRampLength());
        this.transformToWorld((Transformable)this.rampSurfaceNormal);
    }

    private void updateCentroid() {
        if (!this.centroidDirty) {
            return;
        }
        EuclidShapeTools.computeRamp3DCentroid((Shape3DPoseReadOnly)this.pose, (Vector3DReadOnly)this.size, (Point3DBasics)this.centroid);
        this.centroidDirty = false;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFrameShape3DPoseBasics getPose() {
        return this.pose;
    }

    @Override
    public FixedFrameVector3DBasics getSize() {
        return this.size;
    }

    @Override
    public FramePoint3DReadOnly getCentroid() {
        return this.centroid;
    }

    @Override
    public FrameVector3DReadOnly getRampSurfaceNormal() {
        return this.rampSurfaceNormal;
    }

    public void getRampSurfaceNormal(Vector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.set((Tuple3DReadOnly)this.rampSurfaceNormal);
    }

    @Override
    public void getRampSurfaceNormal(FixedFrameVector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.set((FrameTuple3DReadOnly)this.rampSurfaceNormal);
    }

    @Override
    public void getRampSurfaceNormal(FrameVector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.setIncludingFrame((FrameTuple3DReadOnly)this.rampSurfaceNormal);
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
        this.pose.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        boolean hasBeenRemoved = this.changeListeners.remove(listener);
        return hasBeenRemoved |= this.pose.removeChangeListener(listener);
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    public void set(FrameRamp3D other) {
        FrameRamp3DBasics.super.set(other);
    }

    public double getRampLength() {
        this.updateRamp();
        return this.rampLength;
    }

    public double getRampIncline() {
        this.updateRamp();
        return this.angleOfRampIncline;
    }

    @Override
    public FrameRamp3D copy() {
        return new FrameRamp3D(this);
    }

    @Override
    public FrameRampPolytope3DView asConvexPolytope() {
        if (this.polytopeView == null) {
            this.polytopeView = new FrameRampPolytope3D(this);
        }
        return this.polytopeView;
    }

    public boolean epsilonEquals(FrameRamp3D other, double epsilon) {
        return FrameRamp3DBasics.super.epsilonEquals((FrameRamp3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameRamp3D other, double epsilon) {
        return FrameRamp3DBasics.super.geometricallyEquals((FrameRamp3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameRamp3DReadOnly) {
            return FrameRamp3DBasics.super.equals((FrameRamp3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.pose, (Object)this.size);
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameRamp3DString(this);
    }
}

