/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.polytope.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.interfaces.SupportingFrameVertexHolder;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameHalfEdge3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FrameFace3DReadOnly
extends Face3DReadOnly,
SupportingFrameVertexHolder {
    public FramePoint3DReadOnly getCentroid();

    public FrameVector3DReadOnly getNormal();

    public FrameBoundingBox3DReadOnly getBoundingBox();

    public List<? extends FrameHalfEdge3DReadOnly> getEdges();

    default public FrameHalfEdge3DReadOnly getEdge(int index) {
        return this.getEdges().get(index);
    }

    default public List<? extends FrameVertex3DReadOnly> getVertices() {
        return this.getEdges().stream().map(FrameHalfEdge3DReadOnly::getOrigin).collect(Collectors.toList());
    }

    default public FrameVertex3DReadOnly getVertex(int index) {
        return this.getEdge(index).getOrigin();
    }

    default public List<? extends FrameHalfEdge3DReadOnly> lineOfSight(Point3DReadOnly observer) {
        return super.lineOfSight(observer);
    }

    default public List<? extends FrameHalfEdge3DReadOnly> lineOfSight(FramePoint3DReadOnly observer) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return this.lineOfSight((Point3DReadOnly)observer);
    }

    default public List<? extends FrameHalfEdge3DReadOnly> lineOfSight(Point3DReadOnly observer, double epsilon) {
        return super.lineOfSight(observer, epsilon);
    }

    default public List<? extends FrameHalfEdge3DReadOnly> lineOfSight(FramePoint3DReadOnly observer, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return this.lineOfSight((Point3DReadOnly)observer, epsilon);
    }

    default public FrameHalfEdge3DReadOnly lineOfSightStart(Point3DReadOnly observer) {
        return (FrameHalfEdge3DReadOnly)super.lineOfSightStart(observer);
    }

    default public FrameHalfEdge3DReadOnly lineOfSightStart(FramePoint3DReadOnly observer) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return this.lineOfSightStart((Point3DReadOnly)observer);
    }

    default public FrameHalfEdge3DReadOnly lineOfSightEnd(Point3DReadOnly observer) {
        return (FrameHalfEdge3DReadOnly)super.lineOfSightEnd(observer);
    }

    default public FrameHalfEdge3DReadOnly lineOfSightEnd(FramePoint3DReadOnly observer) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return this.lineOfSightEnd((Point3DReadOnly)observer);
    }

    default public boolean canObserverSeeEdge(FramePoint3DReadOnly observer, int index) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return super.canObserverSeeEdge((Point3DReadOnly)observer, index);
    }

    default public boolean canObserverSeeEdge(FramePoint3DReadOnly observer, FrameHalfEdge3DReadOnly edge) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return super.canObserverSeeEdge((Point3DReadOnly)observer, (HalfEdge3DReadOnly)edge);
    }

    default public boolean canObserverSeeFace(FramePoint3DReadOnly observer) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return super.canObserverSeeFace((Point3DReadOnly)observer);
    }

    default public boolean canObserverSeeFace(FramePoint3DReadOnly observer, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)observer);
        return super.canObserverSeeFace((Point3DReadOnly)observer, epsilon);
    }

    default public boolean isPointInFaceSupportPlane(FramePoint3DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.isPointInFaceSupportPlane((Point3DReadOnly)query, epsilon);
    }

    default public boolean isPointInside(FramePoint3DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.isPointInside((Point3DReadOnly)query, epsilon);
    }

    default public boolean isPointDirectlyAboveOrBelow(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.isPointDirectlyAboveOrBelow((Point3DReadOnly)query);
    }

    default public FrameFace3DReadOnly getNeighbor(int index) {
        return (FrameFace3DReadOnly)super.getNeighbor(index);
    }

    default public FrameHalfEdge3DReadOnly getCommonEdgeWith(Face3DReadOnly neighbor) {
        return (FrameHalfEdge3DReadOnly)super.getCommonEdgeWith(neighbor);
    }

    default public FrameHalfEdge3DReadOnly getClosestEdge(Point3DReadOnly query) {
        return (FrameHalfEdge3DReadOnly)super.getClosestEdge(query);
    }

    default public FrameHalfEdge3DReadOnly getClosestEdge(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return (FrameHalfEdge3DReadOnly)super.getClosestEdge((Point3DReadOnly)query);
    }

    default public FrameHalfEdge3DReadOnly getClosestVisibleEdge(Point3DReadOnly query) {
        return (FrameHalfEdge3DReadOnly)super.getClosestVisibleEdge(query);
    }

    default public FrameHalfEdge3DReadOnly getClosestVisibleEdge(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return this.getClosestVisibleEdge((Point3DReadOnly)query);
    }

    default public double signedDistanceFromSupportPlane(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.signedDistanceFromSupportPlane((Point3DReadOnly)query);
    }

    default public double distance(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.distance((Point3DReadOnly)query);
    }

    default public double distanceFromSupportPlane(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return super.distanceFromSupportPlane((Point3DReadOnly)query);
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        FramePoint3D projection = new FramePoint3D();
        if (this.orthogonalProjection(pointToProject, (Point3DBasics)projection)) {
            return projection;
        }
        return null;
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(FramePoint3DReadOnly pointToProject) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjectionCopy((Point3DReadOnly)pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject, (ReferenceFrameHolder)projectionToPack);
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    @Override
    default public FrameVertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        return (FrameVertex3DReadOnly)super.getSupportingVertex(supportDirection);
    }

    @Override
    default public FrameVertex3DReadOnly getSupportingVertex(FrameVector3DReadOnly supportDirection) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)supportDirection);
        return this.getSupportingVertex((Vector3DReadOnly)supportDirection);
    }

    default public boolean epsilonEquals(FrameFace3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.epsilonEquals((Face3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameFace3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Face3DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameFace3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (this.getNumberOfEdges() != other.getNumberOfEdges()) {
            return false;
        }
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfEdges(); ++edgeIndex) {
            if (this.getEdge(edgeIndex).equals(other.getEdge(edgeIndex))) continue;
            return false;
        }
        return true;
    }
}

