/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FixedFrameShape3DPose;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameEllipsoid3D
implements FrameEllipsoid3DBasics,
GeometryObject<FrameEllipsoid3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFrameShape3DPose pose = new FixedFrameShape3DPose(this);
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final FixedFrameVector3DBasics radii = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((ReferenceFrameHolder)this, (axis, newValue) -> this.checkRadiusPositive((Axis3D)axis), null);

    public FrameEllipsoid3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 1.0, 1.0);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, double radiusX, double radiusY, double radiusZ) {
        this.setReferenceFrame(referenceFrame);
        this.getRadii().set(radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Vector3DReadOnly radii) {
        this.setReferenceFrame(referenceFrame);
        this.getRadii().set((Tuple3DReadOnly)radii);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(referenceFrame, position, orientation, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.setIncludingFrame(referenceFrame, position, orientation, radii);
    }

    public FrameEllipsoid3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(position, orientation, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.setIncludingFrame(position, orientation, radii);
    }

    public FrameEllipsoid3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly radii) {
        this.setIncludingFrame(position, orientation, radii);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(referenceFrame, pose, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly radii) {
        this.setIncludingFrame(referenceFrame, pose, radii);
    }

    public FrameEllipsoid3D(FramePose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(pose, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(FramePose3DReadOnly pose, Vector3DReadOnly radii) {
        this.setIncludingFrame(pose, radii);
    }

    public FrameEllipsoid3D(FramePose3DReadOnly pose, FrameVector3DReadOnly radii) {
        this.setIncludingFrame(pose, radii);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(referenceFrame, pose, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly radii) {
        this.setIncludingFrame(referenceFrame, pose, radii);
    }

    public FrameEllipsoid3D(FrameShape3DPoseReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setIncludingFrame(pose, radiusX, radiusY, radiusZ);
    }

    public FrameEllipsoid3D(FrameShape3DPoseReadOnly pose, Vector3DReadOnly radii) {
        this.setIncludingFrame(pose, radii);
    }

    public FrameEllipsoid3D(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly radii) {
        this.setIncludingFrame(pose, radii);
    }

    public FrameEllipsoid3D(ReferenceFrame referenceFrame, Ellipsoid3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    public FrameEllipsoid3D(FrameEllipsoid3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFrameShape3DPoseBasics getPose() {
        return this.pose;
    }

    @Override
    public FixedFrameVector3DBasics getRadii() {
        return this.radii;
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    public void set(FrameEllipsoid3D other) {
        FrameEllipsoid3DBasics.super.set(other);
    }

    @Override
    public FrameEllipsoid3D copy() {
        return new FrameEllipsoid3D(this);
    }

    public boolean epsilonEquals(FrameEllipsoid3D other, double epsilon) {
        return FrameEllipsoid3DBasics.super.epsilonEquals((FrameEllipsoid3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameEllipsoid3D other, double epsilon) {
        return FrameEllipsoid3DBasics.super.geometricallyEquals((FrameEllipsoid3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameEllipsoid3DReadOnly) {
            return FrameEllipsoid3DBasics.super.equals((FrameEllipsoid3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.pose, (Object)this.radii);
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameEllipsoid3DString(this);
    }
}

