/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.solution;

import com.eprosima.idl.util.Util;
import com.eprosima.solution.GUIDGenerator;
import com.eprosima.solution.Solution;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class Project {
    private String m_name = null;
    private String m_file = null;
    private ArrayList<String> m_commonsrcfiles = null;
    private ArrayList<String> m_commonincludefiles = null;
    private LinkedHashSet<String> m_dependencies = null;
    String m_guid = null;
    Solution m_parent = null;

    public Project(String name, String file, LinkedHashSet<String> dependencies) {
        this.m_name = name;
        this.m_file = file;
        this.m_dependencies = dependencies;
        this.m_commonsrcfiles = new ArrayList();
        this.m_commonincludefiles = new ArrayList();
    }

    public void setParent(Solution sol) {
        this.m_parent = sol;
    }

    public Solution getParent() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public String getFile() {
        return this.m_file;
    }

    public void addCommonSrcFile(String file) {
        this.m_commonsrcfiles.add(file);
    }

    public ArrayList<String> getCommonSrcFiles() {
        return this.m_commonsrcfiles;
    }

    public void addCommonIncludeFile(String file) {
        this.m_commonincludefiles.add(file);
    }

    public ArrayList<String> getCommonIncludeFiles() {
        return this.m_commonincludefiles;
    }

    public ArrayList<String> getDependencies() {
        ArrayList<String> array = new ArrayList<String>(this.m_dependencies);
        for (int count = 0; count < array.size(); ++count) {
            array.set(count, Util.getIDLFileNameOnly(array.get(count).toString()));
        }
        return array;
    }

    public String getGuid() {
        return GUIDGenerator.genGUID(this.m_file);
    }

    public ArrayList<String> getDependenciesGuids() {
        ArrayList<String> deps = new ArrayList<String>(this.m_dependencies);
        ArrayList<String> array = new ArrayList<String>();
        for (int count = 0; count < deps.size(); ++count) {
            if (this.m_parent.getOS().contains("Windows") && !this.m_parent.existsProject(deps.get(count))) continue;
            array.add(GUIDGenerator.genGUID(deps.get(count)));
        }
        return array;
    }

    public ArrayList<String> getFullDependencies() {
        return new ArrayList<String>(this.m_dependencies);
    }
}

