/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.parser.typecode;

import com.eprosima.idl.context.Context;
import com.eprosima.idl.parser.tree.Annotation;
import com.eprosima.idl.parser.tree.Notebook;
import com.eprosima.idl.parser.typecode.TypeCode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.FormattingTools;

public class Member
implements Notebook {
    private String m_name = null;
    private TypeCode m_typecode = null;
    private HashMap<String, Annotation> m_annotations = null;
    private String m_comments;
    private String m_defaultValue = null;

    public Member() {
        this.m_annotations = new HashMap();
    }

    public Member(TypeCode typecode, String name, String comments) {
        this.m_typecode = typecode;
        this.m_name = name;
        this.m_annotations = new HashMap();
        this.m_comments = comments;
    }

    public String getComments() {
        return this.m_comments;
    }

    public String getName() {
        return this.m_name;
    }

    public String getJavaName() {
        if (this.m_name != null) {
            if (this.m_name.contains("_")) {
                return FormattingTools.underscoredToCamelCase((String)this.m_name, (boolean)true);
            }
            return StringUtils.capitalize((String)this.m_name);
        }
        return null;
    }

    public TypeCode getTypecode() {
        return this.m_typecode;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setTypecode(TypeCode typecode) {
        this.m_typecode = typecode;
    }

    @Override
    public void addAnnotation(Context ctx, Annotation annotation) {
        if (annotation != null) {
            if (annotation.getName().equals("defaultValue")) {
                String parsedValue = annotation.getValue("value");
                if ((parsedValue = parsedValue.replaceAll("null", "")).equals("True") || parsedValue.equals("False")) {
                    parsedValue = parsedValue.toLowerCase();
                } else if (this.getTypecode().getJavaTypename().equals("byte")) {
                    parsedValue = "(byte) " + parsedValue;
                } else if (this.getTypecode().getJavaTypename().equals("double") && parsedValue.equals("inf")) {
                    parsedValue = "Double.POSITIVE_INFINITY";
                }
                this.m_defaultValue = parsedValue;
            }
            this.m_annotations.put(annotation.getName(), annotation);
        }
    }

    @Override
    public Map<String, Annotation> getAnnotations() {
        return this.m_annotations;
    }

    public boolean getHasDefaultValue() {
        return this.m_defaultValue != null;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }
}

