/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.generator.manager;

import com.eprosima.log.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;

public class TemplateGroup {
    private Map<String, StringTemplate> m_templates = new HashMap<String, StringTemplate>();
    private Map<String, List<StringTemplate>> m_extensionstemplates = new HashMap<String, List<StringTemplate>>();

    public void addTemplate(String groupname, StringTemplate template) {
        this.m_templates.put(groupname, template);
    }

    public void addTemplate(String groupname, StringTemplate template, List<StringTemplate> extensionstemplates) {
        this.addTemplate(groupname, template);
        this.m_extensionstemplates.put(groupname + "_" + template.getName(), extensionstemplates);
    }

    public StringTemplate getTemplate(String groupname) {
        StringTemplate template = this.m_templates.get(groupname);
        if (this.m_extensionstemplates.containsKey(groupname + "_" + template.getName())) {
            ArrayList<StringTemplate> extemplates = new ArrayList<StringTemplate>();
            List<StringTemplate> extensions = this.m_extensionstemplates.get(groupname + "_" + template.getName());
            for (StringTemplate extension : extensions) {
                extemplates.add(extension);
            }
            template.setAttribute("extensions", extemplates);
        }
        return template;
    }

    public void setAttribute(String attribute, TemplateGroup tg) {
        if (tg != null) {
            Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
            for (Map.Entry<String, StringTemplate> m : set) {
                StringTemplate template = tg.getTemplate(m.getKey());
                if (template == null) continue;
                Log.printDebug("setting attribute (TemplateGroup) to template group " + m.getKey() + " from " + template.getName() + " to " + m.getValue().getName());
                m.getValue().setAttribute(attribute, (Object)template.toString());
            }
        }
    }

    public void setAttribute(String attribute, Object obj1) {
        Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
        for (Map.Entry<String, StringTemplate> m : set) {
            Log.printDebug("setting attribute (obj1) to template group " + m.getKey() + " to " + m.getValue().getName());
            StringTemplate template = m.getValue();
            template.setAttribute(attribute, obj1);
            List<StringTemplate> extensions = this.m_extensionstemplates.get(m.getKey() + "_" + template.getName());
            if (extensions == null) continue;
            for (StringTemplate extension : extensions) {
                extension.setAttribute(attribute, obj1);
            }
        }
    }

    public void setAttribute(String attribute, Object obj1, Object obj2) {
        Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
        for (Map.Entry<String, StringTemplate> m : set) {
            Log.printDebug("setting attribute (obj1,obj2) to template group " + m.getKey() + " to " + m.getValue().getName());
            m.getValue().setAttribute(attribute, obj1, obj2);
        }
    }

    public void setAttribute(String attribute, Object obj1, Object obj2, Object obj3) {
        Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
        for (Map.Entry<String, StringTemplate> m : set) {
            Log.printDebug("setting attribute (obj1,obj2,obj3) to template group " + m.getKey() + " to " + m.getValue().getName());
            m.getValue().setAttribute(attribute, obj1, obj2, obj3);
        }
    }

    public void setAttribute(String attribute, Object obj1, Object obj2, Object obj3, Object obj4) {
        Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
        for (Map.Entry<String, StringTemplate> m : set) {
            Log.printDebug("setting attribute (obj1,obj2,obj3,obj4) to template group " + m.getKey() + " to " + m.getValue().getName());
            m.getValue().setAttribute(attribute, obj1, obj2, obj3, obj4);
        }
    }

    public void setAttribute(String attribute, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        Set<Map.Entry<String, StringTemplate>> set = this.m_templates.entrySet();
        for (Map.Entry<String, StringTemplate> m : set) {
            Log.printDebug("setting attribute (obj1,obj2,obj3,obj4,obj5) to template group " + m.getKey() + " to " + m.getValue().getName());
            m.getValue().setAttribute(attribute, obj1, obj2, obj3, obj4, obj5);
        }
    }
}

