/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.StateEstimator;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.sensor.implementations.AngularVelocitySensor;
import us.ihmc.ekf.filter.sensor.implementations.LinearAccelerationSensor;
import us.ihmc.ekf.filter.sensor.implementations.LinearVelocitySensor;
import us.ihmc.ekf.filter.sensor.implementations.MagneticFieldSensor;
import us.ihmc.ekf.filter.state.implementations.PoseState;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ImuOrientationEstimatorWithMagnetometerTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double ESTIMATOR_DT = 0.001;
    private static final Random random = new Random(2549862L);

    @Test
    public void testFullOrientationEstimation() {
        for (int i = 0; i < 10; ++i) {
            this.testOnce();
        }
    }

    public void testOnce() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        SixDoFJoint joint = new SixDoFJoint("joint", (RigidBodyBasics)elevator);
        RigidBody body = new RigidBody("body", (JointBasics)joint, 0.1, 0.1, 0.1, 1.0, (Tuple3DReadOnly)new Vector3D());
        RigidBodyTransform imuTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        MovingReferenceFrame measurementFrame = MovingReferenceFrame.constructFrameFixedInParent((String)"MeasurementFrame", (ReferenceFrame)joint.getFrameAfterJoint(), (RigidBodyTransformReadOnly)imuTransform);
        LinearAccelerationSensor linearAccelerationSensor = new LinearAccelerationSensor("Accelerometer", 0.001, (RigidBodyBasics)body, (ReferenceFrame)measurementFrame, false, registry);
        MagneticFieldSensor magneticFieldSensor = new MagneticFieldSensor("Magnetometer", 0.001, (RigidBodyBasics)body, (ReferenceFrame)measurementFrame, registry);
        AngularVelocitySensor angularVelocitySensor = new AngularVelocitySensor("Gyroscope", 0.001, (RigidBodyBasics)body, (ReferenceFrame)measurementFrame, false, registry);
        LinearVelocitySensor linearVelocitySensor = new LinearVelocitySensor("LinearVelocity", 0.001, (RigidBodyBasics)body, (ReferenceFrame)measurementFrame, false, registry);
        List<Sensor> sensors = Arrays.asList(angularVelocitySensor, linearVelocitySensor, linearAccelerationSensor, magneticFieldSensor);
        PoseState poseState = new PoseState("Body", 0.001, (ReferenceFrame)joint.getFrameAfterJoint(), registry);
        RobotState robotState = new RobotState(poseState, Collections.emptyList());
        StateEstimator estimator = new StateEstimator(sensors, robotState, registry);
        RigidBodyTransform initialTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Twist initialTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)joint.getFrameAfterJoint(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameAfterJoint());
        poseState.initialize(initialTransform, (TwistReadOnly)initialTwist);
        FrameVector3D zAxis = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FrameVector3D north = EuclidFrameRandomTools.nextOrthogonalFrameVector3D((Random)random, (FrameVector3DReadOnly)zAxis, (boolean)false);
        magneticFieldSensor.setNorth(north);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        RigidBodyTransform expectedRootTransform = new RigidBodyTransform((Orientation3DReadOnly)expectedOrientation, (Tuple3DReadOnly)new FrameVector3D());
        FrameVector3D gravity = new FrameVector3D((FrameTuple3DReadOnly)zAxis);
        gravity.scale(9.81);
        gravity.applyInverseTransform((Transform)expectedRootTransform);
        gravity.applyInverseTransform((Transform)imuTransform);
        linearAccelerationSensor.setMeasurement((Vector3DReadOnly)gravity);
        FrameVector3D magneticField = new FrameVector3D((FrameTuple3DReadOnly)north);
        magneticField.applyInverseTransform((Transform)expectedRootTransform);
        magneticField.applyInverseTransform((Transform)imuTransform);
        magneticFieldSensor.setMeasurement((Vector3DReadOnly)magneticField);
        ImuOrientationEstimatorWithMagnetometerTest.loadParameters(registry);
        FrameQuaternion actualOrientation = new FrameQuaternion();
        for (int i = 0; i < 20000; ++i) {
            estimator.predict();
            ImuOrientationEstimatorWithMagnetometerTest.updateJoint((SixDoFJointBasics)joint, poseState);
            estimator.correct();
            ImuOrientationEstimatorWithMagnetometerTest.updateJoint((SixDoFJointBasics)joint, poseState);
            poseState.getOrientation(actualOrientation);
        }
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedOrientation, (Orientation3DReadOnly)actualOrientation, (double)1.0E-4);
    }

    private static void updateJoint(SixDoFJointBasics joint, PoseState poseState) {
        RigidBodyTransform jointTransform = new RigidBodyTransform();
        poseState.getTransform(jointTransform);
        joint.setJointConfiguration((RigidBodyTransformReadOnly)jointTransform);
        Twist jointTwist = new Twist();
        poseState.getTwist(jointTwist);
        joint.setJointTwist((TwistReadOnly)jointTwist);
        joint.updateFramesRecursively();
    }

    private static void loadParameters(YoRegistry registry) {
        new DefaultParameterReader().readParametersInRegistry(registry);
    }
}

