/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.function.Predicate;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.log.LogTools;

public class FilterMutationTest {
    private static final Predicate<? super ClassPath.ClassInfo> testClassFilter = ci -> ci.getName().endsWith("Test");
    private static final Predicate<? super ClassPath.ClassInfo> mutationClassFilter = ci -> !testClassFilter.test((ClassPath.ClassInfo)ci);

    public static void main(String[] args) throws IOException {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        ClassPath classPath = ClassPath.from((ClassLoader)FilterMutationTest.class.getClassLoader());
        LogTools.info((String)"Adding classes to mutate:");
        classPath.getTopLevelClassesRecursive("us.ihmc.ekf.filter").stream().filter(mutationClassFilter).forEach(ci -> {
            mutationTestFacilitator.addClassesToMutate(new Class[]{ci.load()});
            System.out.println(ci.getName());
        });
        LogTools.info((String)"Adding test classes:");
        classPath.getTopLevelClassesRecursive("us.ihmc.ekf.filter").stream().filter(testClassFilter).forEach(ci -> {
            mutationTestFacilitator.addTestClassesToRun(new Class[]{ci.load()});
            System.out.println(ci.getName());
        });
        mutationTestFacilitator.doMutationTest();
    }
}

