/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.ekf.filter.state.implementations.PoseState;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PoseStateTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testSize() {
        Random random = new Random(4922L);
        State state = PoseStateTest.createState(random, new YoRegistry("Test"));
        DMatrixRMaj matrix = new DMatrixRMaj(0, 0);
        state.getFMatrix((DMatrix1Row)matrix);
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumRows());
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumCols());
        state.getQMatrix((DMatrix1Row)matrix);
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumRows());
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumCols());
    }

    @Test
    public void testInitialize() {
        Random random = new Random(4922L);
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        RigidBodyTransform expectedTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Twist expectedTwist = new Twist(bodyFrame, bodyFrame.getParent(), bodyFrame);
        expectedTwist.getAngularPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        expectedTwist.getLinearPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        YoRegistry registry = new YoRegistry("Test");
        PoseState state = new PoseState("root", random.nextDouble(), bodyFrame, registry);
        state.initialize(expectedTransform, (TwistReadOnly)expectedTwist);
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        state.getTransform(actualTransform);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-12);
        Twist actualTwist = new Twist();
        state.getTwist(actualTwist);
        Assertions.assertTrue((boolean)expectedTwist.epsilonEquals(actualTwist, 1.0E-12));
        FrameVector3D actualAngularVelocity = new FrameVector3D();
        FrameVector3D actualLinearVelocity = new FrameVector3D();
        state.getAngularVelocity(actualAngularVelocity);
        state.getLinearVelocity(actualLinearVelocity);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D((Tuple3DReadOnly)expectedTwist.getAngularPart()), (EuclidGeometry)actualAngularVelocity, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D((Tuple3DReadOnly)expectedTwist.getLinearPart()), (EuclidGeometry)actualLinearVelocity, (double)1.0E-12);
        FrameVector3D zero = new FrameVector3D(bodyFrame);
        FrameVector3D actualAngularAcceleration = new FrameVector3D();
        FrameVector3D actualLinearAcceleration = new FrameVector3D();
        state.getAngularAcceleration(actualAngularAcceleration);
        state.getLinearAcceleration(actualLinearAcceleration);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)zero, (EuclidFrameGeometry)actualAngularAcceleration, (double)1.0E-12);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)zero, (EuclidFrameGeometry)actualLinearAcceleration, (double)1.0E-12);
    }

    @Test
    public void testStateVector() {
        Random random = new Random(4922L);
        for (int test = 0; test < 50; ++test) {
            int i;
            State state = PoseStateTest.createState(random, new YoRegistry("Test"));
            DMatrixRMaj expectedState = new DMatrixRMaj(state.getSize(), 1);
            for (int i2 = 0; i2 < state.getSize(); ++i2) {
                expectedState.set(i2, random.nextDouble());
            }
            state.setStateVector((DMatrix1Row)expectedState);
            DMatrixRMaj actualState = new DMatrixRMaj(0, 0);
            state.getStateVector((DMatrix1Row)actualState);
            for (i = 0; i < 0; ++i) {
                Assertions.assertEquals((double)expectedState.get(i), (double)actualState.get(i), (double)Double.MIN_VALUE);
            }
            for (i = 0; i < 3; ++i) {
                Assertions.assertEquals((double)0.0, (double)actualState.get(i), (double)Double.MIN_VALUE);
            }
            for (i = 3; i < state.getSize(); ++i) {
                Assertions.assertEquals((double)expectedState.get(i), (double)actualState.get(i), (double)Double.MIN_VALUE);
            }
        }
    }

    @Test
    public void testPredictionAgainstAMatrix() {
        Random random = new Random(4922L);
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        for (int test = 0; test < 50; ++test) {
            double difference;
            int i;
            PoseState state = new PoseState("root", random.nextDouble(), bodyFrame, new YoRegistry("Test"));
            DMatrixRMaj initialState = new DMatrixRMaj(state.getSize(), 1);
            for (int i2 = 0; i2 < state.getSize(); ++i2) {
                initialState.set(i2, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            }
            state.setStateVector((DMatrix1Row)initialState);
            FrameQuaternion initialOrientation = new FrameQuaternion();
            state.getOrientation(initialOrientation);
            for (int i3 = 0; i3 < 3; ++i3) {
                initialState.set(i3, 0.0);
            }
            DMatrixRMaj A = new DMatrixRMaj(0, 0);
            state.getFMatrix((DMatrix1Row)A);
            DMatrixRMaj predicted = new DMatrixRMaj(state.getSize(), 1);
            state.predict();
            state.getStateVector((DMatrix1Row)predicted);
            DMatrixRMaj linearized = new DMatrixRMaj(state.getSize(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)initialState, (DMatrix1Row)linearized);
            for (i = 0; i < 0; ++i) {
                difference = Math.abs(predicted.get(i) - linearized.get(i));
                Assertions.assertTrue((difference < 1.0E-12 ? 1 : 0) != 0, (String)("Failed on state " + i + " with difference " + difference));
            }
            for (i = 3; i < state.getSize(); ++i) {
                difference = Math.abs(predicted.get(i) - linearized.get(i));
                Assertions.assertTrue((difference < 1.0E-12 ? 1 : 0) != 0, (String)("Failed on state " + i + " with difference " + difference));
            }
            for (i = 0; i < 3; ++i) {
                Assertions.assertEquals((double)predicted.get(i), (double)0.0, (double)Double.MIN_VALUE);
            }
            Vector3D rotationVectorFromLinearization = new Vector3D();
            FrameQuaternion orientationFromLinearization = new FrameQuaternion();
            rotationVectorFromLinearization.set(0, (DMatrix)linearized);
            orientationFromLinearization.setIncludingFrame((FrameQuaternionReadOnly)initialOrientation);
            state.add((QuaternionBasics)orientationFromLinearization, (Vector3DReadOnly)rotationVectorFromLinearization);
            FrameQuaternion orientationFromPrediction = new FrameQuaternion();
            state.getOrientation(orientationFromPrediction);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)orientationFromPrediction, (EuclidGeometry)orientationFromLinearization, (double)1.0E-12);
        }
    }

    private static State createState(Random random, YoRegistry registry) {
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        PoseState poseState = new PoseState("root", random.nextDouble(), bodyFrame, registry);
        new DefaultParameterReader().readParametersInRegistry(registry);
        return poseState;
    }
}

