/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.ImuOrientationEstimator;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ImuOrientationEstimatorTest {
    private static final int TEST_ITERATIONS = 50;
    private static final Random RANDOM = new Random(422L);
    private static final double BODY_ORIENTATION_EPSILON = 0.005;
    private static final double MAX_ANGLE = 1.5707963267948966;
    private static final double ESTIMATOR_DT = 0.001;
    private static final int FILTER_ITERATIONS = 10000;

    @Test
    public void testImuBasedOrientationEstimation() {
        for (int i = 0; i < 50; ++i) {
            this.testImuBasedOrientationEstimationOnce();
        }
    }

    public void testImuBasedOrientationEstimationOnce() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        ImuOrientationEstimator orientationEstimator = new ImuOrientationEstimator(0.001, registry);
        ImuOrientationEstimatorTest.loadParameters(registry);
        double expectedPitch = EuclidCoreRandomTools.nextDouble((Random)RANDOM, (double)1.5707963267948966);
        double expectedRoll = EuclidCoreRandomTools.nextDouble((Random)RANDOM, (double)1.5707963267948966);
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.setYawPitchRoll(0.0, expectedPitch, expectedRoll);
        Vector3D linearAccelerationMeasurement = new Vector3D(0.0, 0.0, 9.81);
        rotationMatrix.inverseTransform((Tuple3DBasics)linearAccelerationMeasurement);
        Vector3D angularVelocityMeasurement = new Vector3D();
        double actualPitch = Double.NaN;
        double actualRoll = Double.NaN;
        for (int i = 0; i < 10000; ++i) {
            orientationEstimator.update((Vector3DReadOnly)angularVelocityMeasurement, (Vector3DReadOnly)linearAccelerationMeasurement);
            FrameQuaternionReadOnly orientationEstimate = orientationEstimator.getOrientationEstimate();
            actualPitch = orientationEstimate.getPitch();
            actualRoll = orientationEstimate.getRoll();
        }
        Assertions.assertEquals((double)expectedPitch, (double)actualPitch, (double)0.005);
        Assertions.assertEquals((double)expectedRoll, (double)actualRoll, (double)0.005);
    }

    private static void loadParameters(YoRegistry registry) {
        new DefaultParameterReader().readParametersInRegistry(registry);
    }
}

