/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.ekf.TestTools;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotStateIndexProvider;

public class FilterToolsTest {
    @Test
    public void testInsertForVelocitySimpleCase() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 9);
        String joint2Name = "Joint2";
        jointNames.add(joint2Name);
        indexMap.put((Object)joint2Name, 3);
        String joint3Name = "Joint3";
        jointNames.add(joint3Name);
        indexMap.put((Object)joint3Name, 7);
        int size = 12;
        int rows = 2;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, false, size);
        DMatrixRMaj matrixToPack = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj matrixToInsert = new DMatrixRMaj(rows, 3);
        matrixToInsert.set(0, 0, 1.0);
        matrixToInsert.set(1, 0, 1.0);
        matrixToInsert.set(0, 1, 2.0);
        matrixToInsert.set(1, 1, 3.0);
        matrixToInsert.set(0, 2, 1.0);
        matrixToInsert.set(1, 2, 9.0);
        FilterTools.insertForVelocity((DMatrix1Row)matrixToPack, jointNames, (DMatrix1Row)matrixToInsert, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(rows, size);
        expected.zero();
        expected.set(0, 10, 1.0);
        expected.set(1, 10, 1.0);
        expected.set(0, 4, 2.0);
        expected.set(1, 4, 3.0);
        expected.set(0, 8, 1.0);
        expected.set(1, 8, 9.0);
        TestTools.assertEquals(expected, matrixToPack);
    }

    @Test
    public void testInsertForVelocityFloating() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 22);
        int size = 34;
        int rows = 1;
        Random random = new Random(2837L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, true, size);
        DMatrixRMaj matrixToPack = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj matrixToInsert = new DMatrixRMaj(rows, 7);
        matrixToInsert.set(0, 0, 1.0);
        matrixToInsert.set(0, 1, 2.0);
        matrixToInsert.set(0, 2, 1.0);
        matrixToInsert.set(0, 3, 6.0);
        matrixToInsert.set(0, 4, 8.0);
        matrixToInsert.set(0, 5, 1.0);
        matrixToInsert.set(0, 6, 9.0);
        FilterTools.insertForVelocity((DMatrix1Row)matrixToPack, jointNames, (DMatrix1Row)matrixToInsert, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(rows, size);
        expected.zero();
        expected.set(0, 3, 1.0);
        expected.set(0, 4, 2.0);
        expected.set(0, 5, 1.0);
        expected.set(0, 12, 6.0);
        expected.set(0, 13, 8.0);
        expected.set(0, 14, 1.0);
        expected.set(0, 23, 9.0);
        TestTools.assertEquals(expected, matrixToPack);
    }

    @Test
    public void testInsertForAccelerationSimpleCase() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 9);
        String joint2Name = "Joint2";
        jointNames.add(joint2Name);
        indexMap.put((Object)joint2Name, 3);
        String joint3Name = "Joint3";
        jointNames.add(joint3Name);
        indexMap.put((Object)joint3Name, 7);
        int size = 12;
        int rows = 2;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, false, size);
        DMatrixRMaj matrixToPack = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj matrixToInsert = new DMatrixRMaj(rows, 3);
        matrixToInsert.set(0, 0, 1.0);
        matrixToInsert.set(1, 0, 1.0);
        matrixToInsert.set(0, 1, 2.0);
        matrixToInsert.set(1, 1, 3.0);
        matrixToInsert.set(0, 2, 1.0);
        matrixToInsert.set(1, 2, 9.0);
        FilterTools.insertForAcceleration((DMatrix1Row)matrixToPack, jointNames, (DMatrix1Row)matrixToInsert, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(rows, size);
        expected.zero();
        expected.set(0, 11, 1.0);
        expected.set(1, 11, 1.0);
        expected.set(0, 5, 2.0);
        expected.set(1, 5, 3.0);
        expected.set(0, 9, 1.0);
        expected.set(1, 9, 9.0);
        TestTools.assertEquals(expected, matrixToPack);
    }

    @Test
    public void testInsertForAccelerationFloating() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 22);
        int size = 34;
        int rows = 1;
        Random random = new Random(2837L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, true, size);
        DMatrixRMaj matrixToPack = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj matrixToInsert = new DMatrixRMaj(rows, 7);
        matrixToInsert.set(0, 0, 1.0);
        matrixToInsert.set(0, 1, 2.0);
        matrixToInsert.set(0, 2, 1.0);
        matrixToInsert.set(0, 3, 6.0);
        matrixToInsert.set(0, 4, 8.0);
        matrixToInsert.set(0, 5, 1.0);
        matrixToInsert.set(0, 6, 9.0);
        FilterTools.insertForAcceleration((DMatrix1Row)matrixToPack, jointNames, (DMatrix1Row)matrixToInsert, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(rows, size);
        expected.zero();
        expected.set(0, 6, 1.0);
        expected.set(0, 7, 2.0);
        expected.set(0, 8, 1.0);
        expected.set(0, 15, 6.0);
        expected.set(0, 16, 8.0);
        expected.set(0, 17, 1.0);
        expected.set(0, 24, 9.0);
        TestTools.assertEquals(expected, matrixToPack);
    }

    @Test
    public void testPackQdSimpleCase() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 9);
        String joint2Name = "Joint2";
        jointNames.add(joint2Name);
        indexMap.put((Object)joint2Name, 3);
        String joint3Name = "Joint3";
        jointNames.add(joint3Name);
        indexMap.put((Object)joint3Name, 7);
        int size = 12;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, false, size);
        DMatrixRMaj qdVector = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj stateVector = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        FilterTools.packQd((DMatrix1Row)qdVector, jointNames, (DMatrix1Row)stateVector, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(3, 1);
        expected.zero();
        expected.set(0, 0, stateVector.get(10));
        expected.set(1, 0, stateVector.get(4));
        expected.set(2, 0, stateVector.get(8));
        TestTools.assertEquals(expected, qdVector);
    }

    @Test
    public void testPackQdFloating() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 35);
        int size = 43;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, true, size);
        DMatrixRMaj qdVector = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj stateVector = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        FilterTools.packQd((DMatrix1Row)qdVector, jointNames, (DMatrix1Row)stateVector, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(7, 1);
        expected.zero();
        expected.set(0, 0, stateVector.get(3));
        expected.set(1, 0, stateVector.get(4));
        expected.set(2, 0, stateVector.get(5));
        expected.set(3, 0, stateVector.get(12));
        expected.set(4, 0, stateVector.get(13));
        expected.set(5, 0, stateVector.get(14));
        expected.set(6, 0, stateVector.get(36));
        TestTools.assertEquals(expected, qdVector);
    }

    @Test
    public void testPackQddSimpleCase() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 9);
        String joint2Name = "Joint2";
        jointNames.add(joint2Name);
        indexMap.put((Object)joint2Name, 3);
        String joint3Name = "Joint3";
        jointNames.add(joint3Name);
        indexMap.put((Object)joint3Name, 7);
        int size = 12;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, false, size);
        DMatrixRMaj qdVector = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj stateVector = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        FilterTools.packQdd((DMatrix1Row)qdVector, jointNames, (DMatrix1Row)stateVector, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(3, 1);
        expected.zero();
        expected.set(0, 0, stateVector.get(11));
        expected.set(1, 0, stateVector.get(5));
        expected.set(2, 0, stateVector.get(9));
        TestTools.assertEquals(expected, qdVector);
    }

    @Test
    public void testPackQddFloating() {
        ArrayList<String> jointNames = new ArrayList<String>();
        TObjectIntHashMap indexMap = new TObjectIntHashMap();
        String joint1Name = "Joint1";
        jointNames.add(joint1Name);
        indexMap.put((Object)joint1Name, 35);
        int size = 43;
        Random random = new Random(23L);
        IndexProvider indexProvider = new IndexProvider((TObjectIntMap<String>)indexMap, true, size);
        DMatrixRMaj qdVector = TestTools.nextMatrix(random.nextInt(200), random.nextInt(200), random, -1.0, 1.0);
        DMatrixRMaj stateVector = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        FilterTools.packQdd((DMatrix1Row)qdVector, jointNames, (DMatrix1Row)stateVector, (RobotStateIndexProvider)indexProvider);
        DMatrixRMaj expected = new DMatrixRMaj(7, 1);
        expected.zero();
        expected.set(0, 0, stateVector.get(6));
        expected.set(1, 0, stateVector.get(7));
        expected.set(2, 0, stateVector.get(8));
        expected.set(3, 0, stateVector.get(15));
        expected.set(4, 0, stateVector.get(16));
        expected.set(5, 0, stateVector.get(17));
        expected.set(6, 0, stateVector.get(37));
        TestTools.assertEquals(expected, qdVector);
    }

    @Test
    public void testSetIdentity() {
        Random random = new Random(640L);
        for (int i = 0; i < 50; ++i) {
            int size = random.nextInt(100);
            DMatrixRMaj actual = TestTools.nextMatrix(random.nextInt(100), random.nextInt(100), random, -1.0, 1.0);
            FilterTools.setIdentity((DMatrix1Row)actual, (int)size);
            DMatrixRMaj expected = new DMatrixRMaj(size, size);
            expected.zero();
            for (int j = 0; j < size; ++j) {
                expected.set(j, j, 1.0);
            }
            TestTools.assertEquals(expected, actual);
        }
    }

    @Test
    public void testCheckDimensions() {
        DMatrixRMaj matrix1 = new DMatrixRMaj(0, 0);
        DMatrixRMaj matrix2 = new DMatrixRMaj(0, 0);
        Assertions.assertThrows(RuntimeException.class, () -> FilterTools.checkVectorDimensions((DMatrix1Row)matrix1, (DMatrix1Row)matrix2));
        int rows = 5;
        matrix1.reshape(rows, 1);
        matrix2.reshape(rows, 1);
        Assertions.assertDoesNotThrow(() -> FilterTools.checkVectorDimensions((DMatrix1Row)matrix1, (DMatrix1Row)matrix2));
        matrix1.reshape(rows, 1);
        matrix2.reshape(rows + 2, 1);
        Assertions.assertThrows(RuntimeException.class, () -> FilterTools.checkVectorDimensions((DMatrix1Row)matrix1, (DMatrix1Row)matrix2));
        matrix1.reshape(rows, 2);
        matrix2.reshape(rows, 1);
        Assertions.assertThrows(RuntimeException.class, () -> FilterTools.checkVectorDimensions((DMatrix1Row)matrix1, (DMatrix1Row)matrix2));
        matrix1.reshape(rows + 6, 1);
        matrix2.reshape(rows, 1);
        Assertions.assertThrows(RuntimeException.class, () -> FilterTools.checkVectorDimensions((DMatrix1Row)matrix1, (DMatrix1Row)matrix2));
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(FilterTools.class, FilterToolsTest.class);
    }

    private class IndexProvider
    implements RobotStateIndexProvider {
        private final TObjectIntMap<String> indexMap;
        private final boolean floating;
        private final int size;

        public IndexProvider(TObjectIntMap<String> indexMap, boolean floating, int size) {
            this.indexMap = indexMap;
            this.floating = floating;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isFloating() {
            return this.floating;
        }

        public int getJointStartIndex(String jointName) {
            return this.indexMap.get((Object)jointName);
        }
    }
}

