/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.TestTools;
import us.ihmc.ekf.filter.sensor.implementations.LinearAccelerationSensor;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearAccelerationSensorTest {
    private static final double EPSILON = 1.0E-5;
    private static final double MAX_PERTUBATION = 1.0E-4;

    @Test
    public void testCrossProductDerivative() {
        RigidBody rootBody;
        int n = 10;
        Random random = new Random(24359L);
        RigidBody imuBody = rootBody = new RigidBody("RootBody", ReferenceFrame.getWorldFrame());
        for (int i = 0; i < n; ++i) {
            RevoluteJoint joint = new RevoluteJoint("Joint" + i, (RigidBodyBasics)imuBody, (RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
            imuBody = new RigidBody("Body" + i, (JointBasics)joint, 0.1, 0.1, 0.1, 1.0, (Tuple3DReadOnly)new Vector3D());
        }
        LinearAccelerationSensor sensor = new LinearAccelerationSensor("TestSensor", 0.01, (RigidBodyBasics)imuBody, ReferenceFrame.getWorldFrame(), false, new YoRegistry("TestRegistry"));
        DMatrixRMaj crossProductLinearization = new DMatrixRMaj(0, 0);
        for (int i = 0; i < 50; ++i) {
            DMatrixRMaj qd0 = TestTools.nextMatrix(n, 1, random, -5.0, 5.0);
            DMatrixRMaj A = TestTools.nextMatrix(3, n, random, -5.0, 5.0);
            DMatrixRMaj L = TestTools.nextMatrix(3, n, random, -5.0, 5.0);
            crossProductLinearization.reshape(3, n);
            DMatrixRMaj qd_pertubation = TestTools.nextMatrix(n, 1, random, 1.0E-4, 1.0E-4);
            DMatrixRMaj qd1 = (DMatrixRMaj)((SimpleMatrix)LinearAccelerationSensorTest.simple(qd0).plus((SimpleBase)LinearAccelerationSensorTest.simple(qd_pertubation))).getMatrix();
            DMatrixRMaj nominal = LinearAccelerationSensorTest.computeAqdxLqd(A, L, qd0);
            DMatrixRMaj expected = LinearAccelerationSensorTest.computeAqdxLqd(A, L, qd1);
            sensor.linearizeCrossProduct((DMatrix1Row)A, (DMatrix1Row)L, (DMatrix1Row)qd0, (DMatrix1Row)crossProductLinearization);
            DMatrixRMaj result_pertubation = (DMatrixRMaj)((SimpleMatrix)LinearAccelerationSensorTest.simple(crossProductLinearization).mult((SimpleBase)LinearAccelerationSensorTest.simple(qd_pertubation))).getMatrix();
            DMatrixRMaj actual = (DMatrixRMaj)((SimpleMatrix)LinearAccelerationSensorTest.simple(nominal).plus((SimpleBase)LinearAccelerationSensorTest.simple(result_pertubation))).getMatrix();
            try {
                TestTools.assertEquals(expected, nominal, 1.0E-5);
                throw new RuntimeException("Change epsilon the test is not actually testing what we want.");
            }
            catch (AssertionError assertionError) {
                TestTools.assertEquals(expected, actual, 1.0E-5);
                continue;
            }
        }
    }

    private static SimpleMatrix simple(DMatrixRMaj matrix) {
        return new SimpleMatrix((Matrix)matrix);
    }

    private static DMatrixRMaj computeAqdxLqd(DMatrixRMaj A, DMatrixRMaj L, DMatrixRMaj qd) {
        SimpleMatrix qd_simple = new SimpleMatrix((Matrix)qd);
        SimpleMatrix A_simple = new SimpleMatrix((Matrix)A);
        SimpleMatrix L_simple = new SimpleMatrix((Matrix)L);
        Vector3D Aqd = new Vector3D();
        Aqd.set((DMatrix)((SimpleMatrix)A_simple.mult((SimpleBase)qd_simple)).getDDRM());
        Vector3D Lqd = new Vector3D();
        Lqd.set((DMatrix)((SimpleMatrix)L_simple.mult((SimpleBase)qd_simple)).getDDRM());
        Vector3D result = new Vector3D();
        result.cross((Tuple3DReadOnly)Aqd, (Tuple3DReadOnly)Lqd);
        DMatrixRMaj ret = new DMatrixRMaj(3, 1);
        result.get((DMatrix)ret);
        return ret;
    }
}

