/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import schemacrawler.crawl.WeakAssociation;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Identifiers;

public final class MetaDataUtility {
    public static Collection<List<String>> allIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, false);
    }

    public static List<String> columnNames(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column indexColumn : index) {
            columnNames.add(indexColumn.getFullName());
        }
        return columnNames;
    }

    public static String constructForeignKeyName(Column pkColumn, Column fkColumn) {
        Objects.requireNonNull(pkColumn, "No primary key column provided");
        Objects.requireNonNull(fkColumn, "No foreign key column provided");
        Table pkTable = (Table)pkColumn.getParent();
        Table fkParent = (Table)fkColumn.getParent();
        String pkHex = Integer.toHexString(pkTable.getFullName().hashCode());
        String fkHex = Integer.toHexString(fkParent.getFullName().hashCode());
        String foreignKeyName = String.format("SC_%s_%s", pkHex, fkHex).toUpperCase();
        return foreignKeyName;
    }

    public static boolean containsGeneratedColumns(Index index) {
        if (index == null) {
            return false;
        }
        for (Column indexColumn : index) {
            if (!indexColumn.isGenerated()) continue;
            return true;
        }
        return false;
    }

    public static void createWeakAssociation(Column pkColumn, Column fkColumn) {
        boolean isPkColumnPartial = pkColumn instanceof PartialDatabaseObject;
        boolean isFkColumnPartial = fkColumn instanceof PartialDatabaseObject;
        if (pkColumn == null || fkColumn == null || isFkColumnPartial && isPkColumnPartial) {
            return;
        }
        String foreignKeyName = MetaDataUtility.constructForeignKeyName(pkColumn, fkColumn);
        WeakAssociation weakAssociation = new WeakAssociation(foreignKeyName);
        weakAssociation.addColumnReference(pkColumn, fkColumn);
        ((Table)fkColumn.getParent()).addWeakAssociation(weakAssociation);
        ((Table)pkColumn.getParent()).addWeakAssociation(weakAssociation);
    }

    public static ForeignKeyCardinality findForeignKeyCardinality(BaseForeignKey<?> foreignKey) {
        if (foreignKey == null) {
            return ForeignKeyCardinality.unknown;
        }
        boolean isForeignKeyUnique = MetaDataUtility.isForeignKeyUnique(foreignKey);
        ColumnReference columnRef0 = (ColumnReference)foreignKey.getColumnReferences().get(0);
        Column fkColumn = columnRef0.getForeignKeyColumn();
        boolean isColumnReference = fkColumn instanceof PartialDatabaseObject;
        ForeignKeyCardinality connectivity = isColumnReference ? ForeignKeyCardinality.unknown : (isForeignKeyUnique ? ForeignKeyCardinality.zero_one : ForeignKeyCardinality.zero_many);
        return connectivity;
    }

    public static List<String> foreignKeyColumnNames(BaseForeignKey<? extends ColumnReference> foreignKey) {
        if (foreignKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference columnReference : foreignKey) {
            columnNames.add(columnReference.getForeignKeyColumn().getFullName());
        }
        return columnNames;
    }

    public static <REF extends ColumnReference, FK extends BaseForeignKey<REF>> String getColumnsListAsString(FK fk, TableRelationshipType relationshipType, IdentifierQuotingStrategy quotingStrategy, String quoteString) {
        Objects.requireNonNull(fk, "No foreign key provided");
        Objects.requireNonNull(quotingStrategy, "No identifier quoting strategy provided");
        if (relationshipType == null || relationshipType == TableRelationshipType.none) {
            return "";
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (ColumnReference columnReference : fk.getColumnReferences()) {
            switch (relationshipType) {
                case parent: {
                    columns.add(columnReference.getPrimaryKeyColumn());
                    break;
                }
                case child: {
                    columns.add(columnReference.getForeignKeyColumn());
                    break;
                }
            }
        }
        return MetaDataUtility.joinColumns(quotingStrategy, quoteString, columns);
    }

    public static String getColumnsListAsString(Index index, IdentifierQuotingStrategy quotingStrategy, String quoteString) {
        Objects.requireNonNull(index, "No index provided");
        Objects.requireNonNull(quotingStrategy, "No identifier quoting strategy provided");
        List<IndexColumn> columns = index.getColumns();
        return MetaDataUtility.joinColumns(quotingStrategy, quoteString, columns);
    }

    public static String getColumnsListAsString(Table table, IdentifierQuotingStrategy quotingStrategy, String quoteString) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(quotingStrategy, "No identifier quoting strategy provided");
        List<Column> columns = table.getColumns();
        return MetaDataUtility.joinColumns(quotingStrategy, quoteString, columns);
    }

    public static String getColumnsListAsString(TableConstraint tableConstraint, IdentifierQuotingStrategy quotingStrategy, String quoteString) {
        Objects.requireNonNull(tableConstraint, "No table constraint provided");
        Objects.requireNonNull(quotingStrategy, "No identifier quoting strategy provided");
        List<TableConstraintColumn> columns = tableConstraint.getColumns();
        return MetaDataUtility.joinColumns(quotingStrategy, quoteString, columns);
    }

    public static boolean isForeignKeyUnique(BaseForeignKey<?> foreignKey) {
        if (foreignKey == null) {
            return false;
        }
        ColumnReference columnRef0 = (ColumnReference)foreignKey.getColumnReferences().get(0);
        Table fkTable = (Table)columnRef0.getForeignKeyColumn().getParent();
        Collection<List<String>> uniqueIndexCoumnNames = MetaDataUtility.uniqueIndexCoumnNames(fkTable);
        List<String> foreignKeyColumnNames = MetaDataUtility.foreignKeyColumnNames(foreignKey);
        return uniqueIndexCoumnNames.contains(foreignKeyColumnNames);
    }

    public static String joinColumns(List<? extends Column> columns, boolean omitLargeObjectColumns, Identifiers identifiers) {
        Objects.requireNonNull(columns, "No columns provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        ArrayList<String> columnsList = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && (javaSqlTypeGroup == JavaSqlTypeGroup.large_object || javaSqlTypeGroup == JavaSqlTypeGroup.object)) continue;
            columnsList.add(identifiers.quoteName(column.getName()));
        }
        return String.join((CharSequence)", ", columnsList);
    }

    public static Collection<List<String>> uniqueIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, true);
    }

    private static Collection<List<String>> indexCoumnNames(Table table, boolean includeUniqueOnly) {
        ArrayList<List<String>> allIndexCoumns = new ArrayList<List<String>>();
        if (table instanceof PartialDatabaseObject) {
            return allIndexCoumns;
        }
        for (Index index : table.getIndexes()) {
            if (includeUniqueOnly && !index.isUnique()) continue;
            List<String> indexColumns = MetaDataUtility.columnNames(index);
            allIndexCoumns.add(indexColumns);
        }
        return allIndexCoumns;
    }

    private static String joinColumns(IdentifierQuotingStrategy quotingStrategy, String quoteString, List<? extends Column> columns) {
        Identifiers identifiers = Identifiers.identifiers().withIdentifierQuotingStrategy(quotingStrategy).withIdentifierQuoteString(quoteString).build();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    private MetaDataUtility() {
    }

    public static enum ForeignKeyCardinality {
        unknown(""),
        zero_one("(0..1)"),
        zero_many("(0..many)"),
        one_one("(1..1)");

        private final String description;

        private ForeignKeyCardinality(String description) {
            this.description = Objects.requireNonNull(description, "No description provided");
        }

        public String toString() {
            return this.description;
        }
    }
}

