/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.Serializable;
import java.util.Objects;
import us.fatehi.utility.Utility;

public final class CommandDescription
implements Serializable,
Comparable<CommandDescription> {
    private static final long serialVersionUID = 2444083929278551904L;
    private final String name;
    private final String description;

    public CommandDescription(String name, String description) {
        this.name = Utility.requireNotBlank(name, "Command name not provided");
        this.description = Utility.isBlank(description) ? null : description;
    }

    @Override
    public int compareTo(CommandDescription otherProperty) {
        if (otherProperty == null) {
            return -1;
        }
        return this.getName().compareToIgnoreCase(otherProperty.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandDescription)) {
            return false;
        }
        CommandDescription other = (CommandDescription)obj;
        return Objects.equals(this.name, other.name);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.description != null) {
            builder.append(" - ").append(this.description);
        }
        return builder.toString();
    }
}

