/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class DatabaseConnectorRegistry
implements Iterable<DatabaseServerType> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseConnectorRegistry.class.getName());
    private static DatabaseConnectorRegistry databaseConnectorRegistrySingleton;
    private final Map<String, DatabaseConnector> databaseConnectorRegistry;

    public static DatabaseConnectorRegistry getDatabaseConnectorRegistry() {
        if (databaseConnectorRegistrySingleton == null) {
            databaseConnectorRegistrySingleton = new DatabaseConnectorRegistry();
        }
        return databaseConnectorRegistrySingleton;
    }

    private static Map<String, DatabaseConnector> loadDatabaseConnectorRegistry() {
        HashMap<String, DatabaseConnector> databaseConnectorRegistry = new HashMap<String, DatabaseConnector>();
        try {
            ServiceLoader<DatabaseConnector> serviceLoader = ServiceLoader.load(DatabaseConnector.class);
            for (DatabaseConnector databaseConnector : serviceLoader) {
                String databaseSystemIdentifier = databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier();
                try {
                    LOGGER.log(Level.CONFIG, new StringFormat("Loading database connector, %s=%s", databaseSystemIdentifier, databaseConnector.getClass().getName()));
                    databaseConnectorRegistry.put(databaseSystemIdentifier, databaseConnector);
                }
                catch (Exception e) {
                    LOGGER.log(Level.CONFIG, new StringFormat("Could not load database connector, %s=%s", databaseSystemIdentifier, databaseConnector.getClass().getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerRuntimeException("Could not load database connector registry", e);
        }
        return databaseConnectorRegistry;
    }

    private static void loadJdbcDrivers() {
        boolean log = LOGGER.isLoggable(Level.CONFIG);
        int index = 0;
        StringBuilder buffer = new StringBuilder(1024);
        try {
            buffer.append("Registered JDBC drivers:").append(System.lineSeparator());
            ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
            for (Driver driver : serviceLoader) {
                ++index;
                if (!log) continue;
                buffer.append(String.format("%2d %50s", index, driver.getClass().getName()));
                try {
                    buffer.append(String.format(" %2d.%d", driver.getMajorVersion(), driver.getMinorVersion()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerRuntimeException("Could not load database drivers", e);
        }
        if (log) {
            LOGGER.log(Level.CONFIG, buffer.toString());
        }
    }

    private DatabaseConnectorRegistry() {
        DatabaseConnectorRegistry.loadJdbcDrivers();
        this.databaseConnectorRegistry = DatabaseConnectorRegistry.loadDatabaseConnectorRegistry();
    }

    public DatabaseConnector findDatabaseConnector(Connection connection) {
        try {
            DatabaseUtility.checkConnection(connection);
            String url = connection.getMetaData().getURL();
            return this.findDatabaseConnectorFromUrl(url);
        }
        catch (SQLException e) {
            return DatabaseConnector.UNKNOWN;
        }
    }

    public DatabaseConnector findDatabaseConnectorFromDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        if (this.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            return this.databaseConnectorRegistry.get(databaseSystemIdentifier);
        }
        return DatabaseConnector.UNKNOWN;
    }

    public DatabaseConnector findDatabaseConnectorFromUrl(String url) {
        if (Utility.isBlank(url)) {
            return DatabaseConnector.UNKNOWN;
        }
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            if (!databaseConnector.supportsUrl(url)) continue;
            return databaseConnector;
        }
        return DatabaseConnector.UNKNOWN;
    }

    public boolean hasDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        return this.databaseConnectorRegistry.containsKey(databaseSystemIdentifier);
    }

    @Override
    public Iterator<DatabaseServerType> iterator() {
        ArrayList<DatabaseServerType> databaseServerTypes = new ArrayList<DatabaseServerType>();
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            databaseServerTypes.add(databaseConnector.getDatabaseServerType());
        }
        databaseServerTypes.sort(Comparator.naturalOrder());
        return databaseServerTypes.iterator();
    }
}

