/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import us.fatehi.utility.Utility;

public abstract class ObjectAttributes
implements Serializable,
Comparable<ObjectAttributes> {
    private static final long serialVersionUID = -6819484903391182146L;
    private final String name;
    private final List<String> remarks;
    private final Map<String, String> attributes;

    public ObjectAttributes(String name, List<String> remarks, Map<String, String> attributes) {
        if (Utility.isBlank(name)) {
            throw new IllegalArgumentException("No name provided");
        }
        this.name = name;
        this.remarks = remarks == null ? Collections.emptyList() : new ArrayList<String>(remarks);
        this.attributes = attributes == null ? Collections.emptyMap() : new TreeMap<String, String>(attributes);
    }

    @Override
    public int compareTo(ObjectAttributes o) {
        if (o == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getRemarks() {
        return String.join((CharSequence)System.lineSeparator(), this.remarks);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasRemarks() {
        if (this.remarks.isEmpty()) {
            return false;
        }
        return !Utility.isBlank(this.getRemarks());
    }
}

