/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes;

import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.loader.attributes.model.CatalogAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributesUtility;
import schemacrawler.loader.attributes.model.ColumnAttributes;
import schemacrawler.loader.attributes.model.TableAttributes;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.StopWatch;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public class AttributesCatalogLoader
extends BaseCatalogLoader {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(AttributesCatalogLoader.class.getName());
    private static final String OPTION_ATTRIBUTES_FILE = "attributes-file";

    public AttributesCatalogLoader() {
        super(new CommandDescription("attributesloader", "Loader for catalog attributes, such as remarks or tags"), 2);
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand(commandDescription.getName(), commandDescription.getDescription());
        pluginCommand.addOption(OPTION_ATTRIBUTES_FILE, String.class, "Path to a YAML file with table and column attributes to add to the schema");
        return pluginCommand;
    }

    @Override
    public void loadCatalog() throws SchemaCrawlerException {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving catalog attributes");
        StopWatch stopWatch = new StopWatch("loadTableRowCounts");
        try {
            Catalog catalog = this.getCatalog();
            Config config = this.getAdditionalConfiguration();
            stopWatch.time("retrieveCatalogAttributes", () -> {
                String catalogAttributesFile = config.getObject(OPTION_ATTRIBUTES_FILE, null);
                if (Utility.isBlank(catalogAttributesFile)) {
                    return null;
                }
                InputResource inputResource = InputResourceUtility.createInputResource(catalogAttributesFile).orElseThrow(() -> new SchemaCrawlerException("Cannot locate catalog attributes file, " + catalogAttributesFile));
                CatalogAttributes catalogAttributes = CatalogAttributesUtility.readCatalogAttributes(inputResource);
                for (TableAttributes tableAttributes : catalogAttributes) {
                    Optional lookupTable = catalog.lookupTable(tableAttributes.getSchema(), tableAttributes.getName());
                    if (!lookupTable.isPresent()) continue;
                    Table table = (Table)lookupTable.get();
                    if (tableAttributes.hasRemarks()) {
                        table.setRemarks(tableAttributes.getRemarks());
                    }
                    for (ColumnAttributes columnAttributes : tableAttributes) {
                        if (!columnAttributes.hasRemarks()) continue;
                        table.lookupColumn(columnAttributes.getName()).ifPresent(column -> column.setRemarks(columnAttributes.getRemarks()));
                    }
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception loading catalog attributes", e);
        }
    }
}

