/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.crawl.WeakAssociationColumnReference;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.NamedObject;
import us.fatehi.utility.CompareUtility;

public final class WeakAssociation
implements BaseForeignKey<WeakAssociationColumnReference> {
    private static final long serialVersionUID = -5164664131926303038L;
    private final String name;
    private final SortedSet<WeakAssociationColumnReference> columnReferences = new TreeSet<WeakAssociationColumnReference>();

    public WeakAssociation(String name) {
        this.name = Objects.requireNonNull(name, "No name provided");
    }

    public void addColumnReference(Column pkColumn, Column fkColumn) {
        this.columnReferences.add(new WeakAssociationColumnReference(pkColumn, fkColumn));
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        BaseForeignKey other = (BaseForeignKey)obj;
        List<WeakAssociationColumnReference> thisColumnReferences = this.getColumnReferences();
        List otherColumnReferences = other.getColumnReferences();
        return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeakAssociation)) {
            return false;
        }
        WeakAssociation other = (WeakAssociation)obj;
        return Objects.equals(this.columnReferences, other.columnReferences);
    }

    @Override
    public List<WeakAssociationColumnReference> getColumnReferences() {
        return new ArrayList<WeakAssociationColumnReference>(this.columnReferences);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.columnReferences);
    }

    @Override
    public Iterator<WeakAssociationColumnReference> iterator() {
        return this.columnReferences.iterator();
    }

    public String toString() {
        return this.columnReferences.toString();
    }

    @Override
    public List<String> toUniqueLookupKey() {
        return Arrays.asList(this.getName());
    }
}

