/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.MutableResultsColumns;
import schemacrawler.crawl.MutableTable;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Schema;
import schemacrawler.utility.JavaSqlTypes;
import us.fatehi.utility.Utility;

final class ResultsRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ResultsRetriever.class.getName());
    private final ResultSetMetaData resultsMetaData;

    ResultsRetriever(ResultSet resultSet) throws SQLException {
        Objects.requireNonNull(resultSet, "Cannot retrieve metadata for null results");
        this.resultsMetaData = resultSet.getMetaData();
    }

    ResultsColumns retrieveResults() throws SQLException {
        JavaSqlTypes javaSqlTypes = new JavaSqlTypes();
        MutableResultsColumns resultColumns = new MutableResultsColumns("");
        MutableCatalog catalog = new MutableCatalog("results");
        int columnCount = this.resultsMetaData.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            String catalogName = this.resultsMetaData.getCatalogName(columnIndex);
            String schemaName = this.resultsMetaData.getSchemaName(columnIndex);
            String tableName = this.resultsMetaData.getTableName(columnIndex);
            if (Utility.isBlank(tableName)) {
                tableName = "";
            }
            Schema schema = catalog.addSchema(catalogName, schemaName);
            MutableTable table = new MutableTable(schema, tableName);
            catalog.addTable(table);
            String columnName = this.resultsMetaData.getColumnName(columnIndex);
            MutableResultsColumn column = new MutableResultsColumn(table, columnName);
            column.setLabel(this.resultsMetaData.getColumnLabel(columnIndex));
            try {
                String databaseSpecificTypeName = this.resultsMetaData.getColumnTypeName(columnIndex);
                int javaSqlType = this.resultsMetaData.getColumnType(columnIndex);
                String columnClassName = this.resultsMetaData.getColumnClassName(columnIndex);
                MutableColumnDataType columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
                columnDataType.setJavaSqlType(javaSqlTypes.valueOf(javaSqlType));
                columnDataType.setTypeMappedClass(columnClassName);
                columnDataType.setPrecision(this.resultsMetaData.getPrecision(columnIndex));
                int scale = this.resultsMetaData.getScale(columnIndex);
                columnDataType.setMaximumScale(scale);
                columnDataType.setMinimumScale(scale);
                column.setColumnDataType(columnDataType);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Could not retrieve column data type for %s (%s)", column, column.getLabel()), (Throwable)e);
                MutableColumnDataType unknownColumnDataType = new MutableColumnDataType(schema, "<unknown>");
                unknownColumnDataType.setJavaSqlType(JavaSqlType.UNKNOWN);
                column.setColumnDataType(unknownColumnDataType);
            }
            try {
                boolean isNullable = this.resultsMetaData.isNullable(columnIndex) == 1;
                column.setOrdinalPosition(columnIndex);
                column.setDisplaySize(this.resultsMetaData.getColumnDisplaySize(columnIndex));
                column.setAutoIncrement(this.resultsMetaData.isAutoIncrement(columnIndex));
                column.setCaseSensitive(this.resultsMetaData.isCaseSensitive(columnIndex));
                column.setCurrency(this.resultsMetaData.isCurrency(columnIndex));
                column.setDefinitelyWritable(this.resultsMetaData.isDefinitelyWritable(columnIndex));
                column.setNullable(isNullable);
                column.setReadOnly(this.resultsMetaData.isReadOnly(columnIndex));
                column.setSearchable(this.resultsMetaData.isSearchable(columnIndex));
                column.setSigned(this.resultsMetaData.isSigned(columnIndex));
                column.setWritable(this.resultsMetaData.isWritable(columnIndex));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Could not retrieve additional column data for %s (%s)", column, column.getLabel()), (Throwable)e);
            }
            resultColumns.addColumn(column);
        }
        return resultColumns;
    }
}

