/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.WeakAssociation;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;
import schemacrawler.utility.NamedObjectSort;

class MutableTable
extends AbstractDatabaseObject
implements Table {
    private static final long serialVersionUID = 3257290248802284852L;
    private final NamedObjectList<MutableColumn> columns = new NamedObjectList();
    private final NamedObjectList<MutableTableConstraint> constraints = new NamedObjectList();
    private final StringBuilder definition;
    private final NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList();
    private final NamedObjectList<WeakAssociation> weakAssociations = new NamedObjectList();
    private final NamedObjectList<MutableColumn> hiddenColumns = new NamedObjectList();
    private final NamedObjectList<MutableIndex> indexes = new NamedObjectList();
    private final NamedObjectList<MutablePrivilege<Table>> privileges = new NamedObjectList();
    private final NamedObjectList<MutableTrigger> triggers = new NamedObjectList();
    private MutablePrimaryKey primaryKey;
    private int sortIndex;
    private TableType tableType = TableType.UNKNOWN;

    MutableTable(Schema schema, String name) {
        super(schema, name);
        this.definition = new StringBuilder();
    }

    @Override
    public final void addWeakAssociation(WeakAssociation weakAssociation) {
        this.weakAssociations.add(weakAssociation);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        int comparison = 0;
        if (comparison == 0 && obj instanceof MutableTable) {
            comparison = this.sortIndex - ((MutableTable)obj).sortIndex;
        }
        if (comparison == 0) {
            comparison = super.compareTo(obj);
        }
        return comparison;
    }

    @Override
    public List<Column> getColumns() {
        return new ArrayList<Column>(this.columns.values());
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public Collection<ForeignKey> getExportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.exported);
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.getForeignKeys(TableAssociationType.all);
    }

    @Override
    public Collection<Column> getHiddenColumns() {
        return new HashSet<Column>(this.hiddenColumns.values());
    }

    @Override
    public Collection<ForeignKey> getImportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.imported);
    }

    @Override
    public Collection<Index> getIndexes() {
        return new ArrayList<Index>(this.indexes.values());
    }

    @Override
    public MutablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Collection<Privilege<Table>> getPrivileges() {
        return new ArrayList<Privilege<Table>>(this.privileges.values());
    }

    @Override
    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        HashSet<Table> relatedTables = new HashSet<Table>();
        if (tableRelationshipType != null && tableRelationshipType != TableRelationshipType.none) {
            ArrayList<MutableForeignKey> foreignKeysList = new ArrayList<MutableForeignKey>(this.foreignKeys.values());
            for (ForeignKey foreignKey : foreignKeysList) {
                for (ForeignKeyColumnReference columnReference : foreignKey) {
                    Table parentTable = (Table)columnReference.getPrimaryKeyColumn().getParent();
                    Table childTable = (Table)columnReference.getForeignKeyColumn().getParent();
                    switch (tableRelationshipType) {
                        case parent: {
                            if (!this.equals(childTable)) break;
                            relatedTables.add(parentTable);
                            break;
                        }
                        case child: {
                            if (!this.equals(parentTable)) break;
                            relatedTables.add(childTable);
                            break;
                        }
                    }
                }
            }
        }
        ArrayList<Table> relatedTablesList = new ArrayList<Table>(relatedTables);
        relatedTablesList.sort(NamedObjectSort.alphabetical);
        return relatedTablesList;
    }

    @Override
    public Collection<TableConstraint> getTableConstraints() {
        return new ArrayList<TableConstraint>(this.constraints.values());
    }

    @Override
    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return new ArrayList<Trigger>(this.triggers.values());
    }

    @Override
    public final TableType getType() {
        return this.getTableType();
    }

    @Override
    public Collection<WeakAssociation> getWeakAssociations() {
        return new ArrayList<WeakAssociation>(this.weakAssociations.values());
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public final boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public Optional<MutableColumn> lookupColumn(String name) {
        Optional<MutableColumn> optionalColumn = this.columns.lookup(this, name);
        if (!optionalColumn.isPresent()) {
            optionalColumn = this.hiddenColumns.lookup(this, name);
        }
        return optionalColumn;
    }

    public Optional<MutableForeignKey> lookupForeignKey(String name) {
        return this.foreignKeys.lookup(this, name);
    }

    public Optional<MutableIndex> lookupIndex(String name) {
        return this.indexes.lookup(this, name);
    }

    public Optional<MutablePrivilege<Table>> lookupPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    public Optional<MutableTableConstraint> lookupTableConstraint(String name) {
        return this.constraints.lookup(this, name);
    }

    public Optional<MutableTrigger> lookupTrigger(String triggerName) {
        return this.triggers.lookup(this, triggerName);
    }

    final void addColumn(MutableColumn column) {
        this.columns.add(column);
    }

    final void addForeignKey(MutableForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    final void addHiddenColumn(MutableColumn column) {
        this.hiddenColumns.add(column);
    }

    final void addIndex(MutableIndex index) {
        this.indexes.add(index);
    }

    final void addPrivilege(MutablePrivilege<Table> privilege) {
        this.privileges.add(privilege);
    }

    final void addTableConstraint(MutableTableConstraint tableConstraint) {
        this.constraints.add(tableConstraint);
    }

    final void addTrigger(MutableTrigger trigger) {
        this.triggers.add(trigger);
    }

    final void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    NamedObjectList<MutableColumn> getAllColumns() {
        return this.columns;
    }

    final void setPrimaryKey(MutablePrimaryKey primaryKey) {
        if (primaryKey == null) {
            return;
        }
        this.primaryKey = primaryKey;
    }

    final void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    final void setTableType(TableType tableType) {
        this.tableType = tableType == null ? TableType.UNKNOWN : tableType;
    }

    private Collection<ForeignKey> getForeignKeys(TableAssociationType tableAssociationType) {
        ArrayList<ForeignKey> foreignKeysList = new ArrayList<ForeignKey>(this.foreignKeys.values());
        if (tableAssociationType != null && tableAssociationType != TableAssociationType.all) {
            Iterator iterator = foreignKeysList.iterator();
            while (iterator.hasNext()) {
                ForeignKey mutableForeignKey = (ForeignKey)iterator.next();
                boolean isExportedKey = false;
                boolean isImportedKey = false;
                for (ForeignKeyColumnReference columnReference : mutableForeignKey) {
                    if (((Table)columnReference.getPrimaryKeyColumn().getParent()).equals(this)) {
                        isExportedKey = true;
                    }
                    if (!((Table)columnReference.getForeignKeyColumn().getParent()).equals(this)) continue;
                    isImportedKey = true;
                }
                switch (tableAssociationType) {
                    case exported: {
                        if (isExportedKey) break;
                        iterator.remove();
                        break;
                    }
                    case imported: {
                        if (isImportedKey) break;
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        return foreignKeysList;
    }

    private static enum TableAssociationType {
        all,
        exported,
        imported;

    }
}

