/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.MutableForeignKeyColumnReference;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.TableConstraintType;
import us.fatehi.utility.CompareUtility;

final class MutableForeignKey
extends AbstractNamedObjectWithAttributes
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private final SortedSet<MutableForeignKeyColumnReference> columnReferences = new TreeSet<MutableForeignKeyColumnReference>();
    private final StringBuilder definition = new StringBuilder();
    private ForeignKeyDeferrability deferrability;
    private ForeignKeyUpdateRule deleteRule;
    private String specificName;
    private ForeignKeyUpdateRule updateRule = ForeignKeyUpdateRule.unknown;

    MutableForeignKey(String name) {
        super(name);
        this.deleteRule = ForeignKeyUpdateRule.unknown;
        this.deferrability = ForeignKeyDeferrability.unknown;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        BaseForeignKey other = (BaseForeignKey)obj;
        List<ForeignKeyColumnReference> thisColumnReferences = this.getColumnReferences();
        List otherColumnReferences = other.getColumnReferences();
        return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
    }

    @Override
    public List<ForeignKeyColumnReference> getColumnReferences() {
        return new ArrayList<ForeignKeyColumnReference>(this.columnReferences);
    }

    @Override
    public TableConstraintType getConstraintType() {
        return TableConstraintType.foreign_key;
    }

    @Override
    public ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isDeferrable() {
        return this.isInitiallyDeferred();
    }

    @Override
    public boolean isInitiallyDeferred() {
        if (this.deferrability == null) {
            throw new NotLoadedException(this);
        }
        return this.deferrability == ForeignKeyDeferrability.initiallyDeferred;
    }

    @Override
    public Iterator<ForeignKeyColumnReference> iterator() {
        return new ArrayList<MutableForeignKeyColumnReference>(this.columnReferences).iterator();
    }

    @Override
    public List<String> toUniqueLookupKey() {
        ArrayList<String> lookupKey = new ArrayList<String>(super.toUniqueLookupKey());
        lookupKey.add(this.specificName);
        return lookupKey;
    }

    void addColumnReference(int keySequence, Column pkColumn, Column fkColumn) {
        MutableForeignKeyColumnReference fkColumnReference = new MutableForeignKeyColumnReference(keySequence, pkColumn, fkColumn);
        this.columnReferences.add(fkColumnReference);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }
}

