/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.BaseProductVersion;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.ProductVersion;
import schemacrawler.SchemaCrawlerInfo;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;

final class MutableCrawlInfo
implements CrawlInfo {
    private static final long serialVersionUID = 5982990326485881993L;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    private final Instant crawlTimestamp;
    private final ProductVersion jvmVersion;
    private final ProductVersion operatingSystemVersion;
    private final UUID runId;
    private final ProductVersion schemaCrawlerVersion = new SchemaCrawlerInfo();
    private ProductVersion databaseVersion;
    private ProductVersion jdbcDriverVersion;

    MutableCrawlInfo() {
        this.operatingSystemVersion = new OperatingSystemInfo();
        this.jvmVersion = new JvmSystemInfo();
        this.crawlTimestamp = Instant.now();
        this.runId = UUID.randomUUID();
    }

    @Override
    public String getCrawlTimestamp() {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(this.crawlTimestamp, ZoneOffset.UTC);
        return DATE_TIME_FORMATTER.format(dateTime);
    }

    @Override
    public Instant getCrawlTimestampInstant() {
        return this.crawlTimestamp;
    }

    @Override
    public ProductVersion getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Override
    public ProductVersion getJdbcDriverVersion() {
        return this.jdbcDriverVersion;
    }

    @Override
    public ProductVersion getJvmVersion() {
        return this.jvmVersion;
    }

    @Override
    public ProductVersion getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    @Override
    public String getRunId() {
        return this.runId.toString();
    }

    @Override
    public ProductVersion getSchemaCrawlerVersion() {
        return this.schemaCrawlerVersion;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- generated by: ").append(this.schemaCrawlerVersion).append(System.lineSeparator());
        info.append("-- generated on: ").append(this.getCrawlTimestamp()).append(System.lineSeparator());
        info.append("-- database: ").append(this.databaseVersion).append(System.lineSeparator());
        info.append("-- driver: ").append(this.jdbcDriverVersion).append(System.lineSeparator());
        info.append("-- operating system: ").append(this.operatingSystemVersion).append(System.lineSeparator());
        info.append("-- JVM system: ").append(this.jvmVersion).append(System.lineSeparator());
        return info.toString();
    }

    void setDatabaseInfo(JdbcDriverInfo jdbcDriverInfo, DatabaseInfo databaseInfo) {
        Objects.requireNonNull(jdbcDriverInfo, "No JDBC driver information provided");
        this.jdbcDriverVersion = new BaseProductVersion(jdbcDriverInfo);
        Objects.requireNonNull(databaseInfo, "No database information provided");
        this.databaseVersion = new BaseProductVersion(databaseInfo);
    }
}

