/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SearchableType;
import schemacrawler.schemacrawler.Identifiers;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class MutableColumnDataType
extends AbstractDatabaseObject
implements ColumnDataType {
    private static final long serialVersionUID = 3688503281676530744L;
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawler.class.getName());
    private boolean autoIncrementable;
    private ColumnDataType baseType;
    private boolean caseSensitive;
    private String createParameters = "";
    private boolean fixedPrecisionScale;
    private transient String fullName;
    private JavaSqlType javaSqlType = JavaSqlType.UNKNOWN;
    private Class<?> javaSqlTypeMappedClass = Object.class;
    private String literalPrefix = "";
    private String literalSuffix = "";
    private String localizedTypeName = "";
    private int maximumScale;
    private int minimumScale;
    private boolean nullable;
    private int numPrecisionRadix;
    private long precision;
    private SearchableType searchable = SearchableType.unknown;
    private boolean unsigned;
    private boolean userDefined;
    private List<String> enumValues = new ArrayList<String>();

    MutableColumnDataType(ColumnDataType columnDataType) {
        this(columnDataType.getSchema(), columnDataType.getName());
        this.autoIncrementable = columnDataType.isAutoIncrementable();
        this.baseType = columnDataType.getBaseType();
        this.caseSensitive = columnDataType.isCaseSensitive();
        this.createParameters = columnDataType.getCreateParameters();
        this.fixedPrecisionScale = columnDataType.isFixedPrecisionScale();
        this.javaSqlType = columnDataType.getJavaSqlType();
        this.javaSqlTypeMappedClass = columnDataType.getTypeMappedClass();
        this.literalPrefix = columnDataType.getLiteralPrefix();
        this.literalSuffix = columnDataType.getLiteralSuffix();
        this.localizedTypeName = columnDataType.getLocalTypeName();
        this.maximumScale = columnDataType.getMaximumScale();
        this.minimumScale = columnDataType.getMinimumScale();
        this.nullable = columnDataType.isNullable();
        this.numPrecisionRadix = columnDataType.getNumPrecisionRadix();
        this.precision = columnDataType.getPrecision();
        this.searchable = columnDataType.getSearchable();
        this.unsigned = columnDataType.isUnsigned();
        this.userDefined = columnDataType.isUserDefined();
        this.enumValues = new ArrayList<String>(columnDataType.getEnumValues());
    }

    MutableColumnDataType(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public ColumnDataType getBaseType() {
        return this.baseType;
    }

    @Override
    public String getCreateParameters() {
        return this.createParameters;
    }

    @Override
    public String getDatabaseSpecificTypeName() {
        return this.getName();
    }

    @Override
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public JavaSqlType getJavaSqlType() {
        return this.javaSqlType;
    }

    @Override
    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    @Override
    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    @Override
    public String getLocalTypeName() {
        return this.localizedTypeName;
    }

    @Override
    public int getMaximumScale() {
        return this.maximumScale;
    }

    @Override
    public int getMinimumScale() {
        return this.minimumScale;
    }

    @Override
    public int getNumPrecisionRadix() {
        return this.numPrecisionRadix;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public SearchableType getSearchable() {
        return this.searchable;
    }

    @Override
    public Class<?> getTypeMappedClass() {
        return this.javaSqlTypeMappedClass;
    }

    @Override
    public boolean isAutoIncrementable() {
        return this.autoIncrementable;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isEnumerated() {
        return !this.enumValues.isEmpty();
    }

    @Override
    public boolean isFixedPrecisionScale() {
        return this.fixedPrecisionScale;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }

    void setAutoIncrementable(boolean autoIncrementable) {
        this.autoIncrementable = autoIncrementable;
    }

    void setBaseType(ColumnDataType baseType) {
        this.baseType = baseType;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    void setCreateParameters(String createParams) {
        this.createParameters = createParams;
    }

    void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues == null ? new ArrayList<String>() : enumValues;
    }

    void setFixedPrecisionScale(boolean fixedPrecisionScale) {
        this.fixedPrecisionScale = fixedPrecisionScale;
    }

    void setJavaSqlType(JavaSqlType javaSqlType) {
        this.javaSqlType = javaSqlType != null ? javaSqlType : JavaSqlType.UNKNOWN;
    }

    void setLiteralPrefix(String literalPrefix) {
        this.literalPrefix = literalPrefix;
    }

    void setLiteralSuffix(String literalSuffix) {
        this.literalSuffix = literalSuffix;
    }

    void setLocalTypeName(String localTypeName) {
        this.localizedTypeName = localTypeName;
    }

    void setMaximumScale(int maximumScale) {
        this.maximumScale = maximumScale;
    }

    void setMinimumScale(int minimumScale) {
        this.minimumScale = minimumScale;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    void setNumPrecisionRadix(int numPrecisionRadix) {
        this.numPrecisionRadix = numPrecisionRadix;
    }

    void setPrecision(long precision) {
        this.precision = precision;
    }

    void setSearchable(SearchableType searchable) {
        this.searchable = searchable;
    }

    void setTypeMappedClass(Class<?> mappedClass) {
        this.javaSqlTypeMappedClass = mappedClass != null ? mappedClass : Object.class;
    }

    void setTypeMappedClass(String mappedClassName) {
        if (!Utility.isBlank(mappedClassName)) {
            try {
                this.javaSqlTypeMappedClass = Class.forName(mappedClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINE, new StringFormat("Could not load mapped class <%s>", mappedClassName), (Throwable)e);
                this.javaSqlTypeMappedClass = Object.class;
            }
        } else {
            this.javaSqlTypeMappedClass = Object.class;
        }
    }

    void setUnsigned(boolean unsignedAttribute) {
        this.unsigned = unsignedAttribute;
    }

    void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        Schema schema = this.getSchema();
        if (!Utility.isBlank(schema.getFullName())) {
            Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
            this.fullName = identifiers.quoteFullName(this);
        } else {
            this.fullName = this.getName();
        }
    }
}

