/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.crawl.ImmutableDatabaseUser;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.crawl.ImmutableServerInfoProperty;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class DatabaseInfoRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseInfoRetriever.class.getName());
    private static final List<String> ignoreMethods = Arrays.asList("getDatabaseProductName", "getDatabaseProductVersion", "getURL", "getUserName", "getDriverName", "getDriverVersion");

    private static boolean isDatabasePropertiesResultSetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isPropertiesResultSetMethod = returnType.equals(ResultSet.class) && method.getParameterTypes().length == 0;
        return isPropertiesResultSetMethod;
    }

    private static boolean isDatabasePropertyListMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isDatabasePropertyListMethod = returnType.equals(String.class) && method.getName().endsWith("s") && method.getParameterTypes().length == 0;
        return isDatabasePropertyListMethod;
    }

    private static boolean isDatabasePropertyMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean notPropertyMethod = returnType.equals(ResultSet.class) || returnType.equals(Connection.class) || method.getParameterTypes().length > 0;
        return !notPropertyMethod;
    }

    private static ImmutableDatabaseProperty retrieveResultSetTypeProperty(DatabaseMetaData dbMetaData, Method method, int resultSetType, String resultSetTypeName) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName() + "For" + resultSetTypeName + "ResultSets";
        Boolean propertyValue = (Boolean)method.invoke((Object)dbMetaData, resultSetType);
        return new ImmutableDatabaseProperty(name, (Object)propertyValue);
    }

    DatabaseInfoRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalDatabaseInfo() {
        Method[] methods;
        DatabaseMetaData dbMetaData = this.getMetaData();
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
        for (Method method : methods = DatabaseMetaData.class.getMethods()) {
            try {
                if (method.getParameterTypes().length > 0 || ignoreMethods.contains(method.getName())) continue;
                LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                Object methodReturnValue = method.invoke((Object)dbMetaData, new Object[0]);
                if (DatabaseInfoRetriever.isDatabasePropertyListMethod(method)) {
                    String value = (String)methodReturnValue;
                    String[] list = value == null ? new String[]{} : value.split(",");
                    dbProperties.add(new ImmutableDatabaseProperty(method.getName(), list));
                    continue;
                }
                if (DatabaseInfoRetriever.isDatabasePropertyMethod(method)) {
                    dbProperties.add(new ImmutableDatabaseProperty(method.getName(), methodReturnValue));
                    continue;
                }
                if (!DatabaseInfoRetriever.isDatabasePropertiesResultSetMethod(method)) continue;
                ResultSet results = (ResultSet)methodReturnValue;
                List<String> resultsList = DatabaseUtility.readResultsVector(results);
                Collections.sort(resultsList);
                dbProperties.add(new ImmutableDatabaseProperty(method.getName(), resultsList.toArray(new String[resultsList.size()])));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.log(Level.FINE, new StringFormat("Could not execute method <%s>", method), e.getCause());
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                this.logSQLFeatureNotSupported(new StringFormat("Database metadata method <%s> not supported", method), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("SQL exception invoking method <%s>", method), e);
            }
        }
        Collection<ImmutableDatabaseProperty> resultSetTypesProperties = this.retrieveResultSetTypesProperties(dbMetaData);
        dbProperties.addAll(resultSetTypesProperties);
        dbInfo.addAll(dbProperties);
    }

    void retrieveAdditionalJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try {
            DriverPropertyInfo[] propertyInfo;
            DatabaseMetaData dbMetaData = this.getMetaData();
            String url = dbMetaData.getURL();
            Driver jdbcDriver = this.getRetrieverConnection().getDriver();
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo = jdbcDriver.getPropertyInfo(url, new Properties())) {
                driverInfo.addJdbcDriverProperty(new ImmutableJdbcDriverProperty(driverPropertyInfo));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain JDBC driver information", (Throwable)e);
        }
    }

    void retrieveCrawlInfo() {
        this.catalog.setCrawlInfo();
    }

    void retrieveDatabaseInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        try {
            DatabaseMetaData dbMetaData = this.getMetaData();
            dbInfo.setUserName(dbMetaData.getUserName());
            dbInfo.setProductName(dbMetaData.getDatabaseProductName());
            dbInfo.setProductVersion(dbMetaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain database information", (Throwable)e);
        }
    }

    void retrieveDatabaseUsers() {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.DATABASE_USERS)) {
            LOGGER.log(Level.INFO, "Not retrieving database users information, since this was not requested");
            LOGGER.log(Level.FINE, "Database users SQL statement was not provided");
            return;
        }
        Query databaseUsersSql = informationSchemaViews.getQuery(InformationSchemaKey.DATABASE_USERS);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(databaseUsersSql, statement, new IncludeAll());){
            results.setDescription("retrieveDatabaseUsers");
            while (results.next()) {
                String username = results.getString("USERNAME");
                if (Utility.isBlank(username)) continue;
                LOGGER.log(Level.FINER, new StringFormat("Retrieving database user: %s", username));
                ImmutableDatabaseUser databaseUser = new ImmutableDatabaseUser(username);
                databaseUser.addAttributes(results.getAttributes());
                this.catalog.addDatabaseUser(databaseUser);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve database users", (Throwable)e);
        }
    }

    void retrieveJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try {
            DatabaseMetaData dbMetaData = this.getMetaData();
            String url = dbMetaData.getURL();
            driverInfo.setDriverName(dbMetaData.getDriverName());
            driverInfo.setDriverVersion(dbMetaData.getDriverVersion());
            driverInfo.setConnectionUrl(url);
            Driver jdbcDriver = this.getRetrieverConnection().getDriver();
            driverInfo.setJdbcDriverClassName(jdbcDriver.getClass().getName());
            driverInfo.setJdbcCompliant(jdbcDriver.jdbcCompliant());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain JDBC driver information", (Throwable)e);
        }
    }

    void retrieveServerInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SERVER_INFORMATION)) {
            LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
            LOGGER.log(Level.FINE, "Server information SQL statement was not provided");
            return;
        }
        Query serverInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.SERVER_INFORMATION);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(serverInfoSql, statement, new IncludeAll());){
            results.setDescription("retrieveServerInfo");
            while (results.next()) {
                String propertyName = results.getString("NAME");
                if (Utility.isBlank(propertyName)) continue;
                String propertyValue = results.getString("VALUE");
                String propertyDescription = results.getString("DESCRIPTION");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving server information property: %s=%s", propertyName, propertyValue));
                ImmutableServerInfoProperty serverInfoProperty = new ImmutableServerInfoProperty(propertyName, propertyValue, propertyDescription);
                dbInfo.addServerInfo(serverInfoProperty);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve server information", (Throwable)e);
        }
    }

    private Collection<ImmutableDatabaseProperty> retrieveResultSetTypesProperties(DatabaseMetaData dbMetaData) {
        String[] resultSetTypesMethods;
        ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
        for (String methodName : resultSetTypesMethods = new String[]{"deletesAreDetected", "insertsAreDetected", "updatesAreDetected", "othersInsertsAreVisible", "othersDeletesAreVisible", "othersUpdatesAreVisible", "ownDeletesAreVisible", "ownInsertsAreVisible", "ownUpdatesAreVisible", "supportsResultSetType"}) {
            try {
                Method method = DatabaseMetaData.class.getMethod(methodName, Integer.TYPE);
                LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1003, "TYPE_FORWARD_ONLY"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1004, "TYPE_SCROLL_INSENSITIVE"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1005, "TYPE_SCROLL_SENSITIVE"));
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, new StringFormat("Could not execute method <%s>", methodName), e.getCause());
            }
        }
        return dbProperties;
    }
}

