/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.logging.Level;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import sf.util.DatabaseUtility;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;

public final class SchemaCrawlerUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        DatabaseUtility.checkConnection((Connection)connection);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, ObjectToString.toString((Object)schemaCrawlerOptions));
        }
        DatabaseSpecificOverrideOptions dbSpecificOverrideOptions = SchemaCrawlerUtility.matchDatabaseSpecificOverrideOptions(connection);
        SchemaCrawler schemaCrawler = new SchemaCrawler(connection, dbSpecificOverrideOptions);
        Catalog catalog = schemaCrawler.crawl(schemaCrawlerOptions);
        return catalog;
    }

    public static ResultsColumns getResultColumns(ResultSet resultSet) {
        return SchemaCrawler.getResultColumns((ResultSet)resultSet);
    }

    public static DatabaseSpecificOverrideOptions matchDatabaseSpecificOverrideOptions(Connection connection) throws SchemaCrawlerException {
        DatabaseConnectorRegistry registry = new DatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.lookupDatabaseConnector(connection);
        DatabaseSpecificOverrideOptions dbSpecificOverrideOptions = dbConnector.getDatabaseSpecificOverrideOptionsBuilder().toOptions();
        LOGGER.log(Level.INFO, "Using database plugin for " + dbConnector.getDatabaseServerType());
        return dbSpecificOverrideOptions;
    }

    private SchemaCrawlerUtility() {
    }
}

