/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility.html;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.text.utility.html.Entities;
import sf.util.Color;
import sf.util.Utility;

abstract class BaseTag {
    private final TextOutputFormat outputFormat;
    private final String styleClass;
    private final int characterWidth;
    private final Alignment align;
    private final String text;
    private final boolean escapeText;
    private final Color bgColor;
    private final boolean emphasizeText;
    private final Map<String, String> attributes;

    private static String escapeAndQuoteCsv(String text) {
        int QUOTE = 34;
        int SEPARATOR = 44;
        String value = String.valueOf(text);
        int length = value.length();
        if (length == 0) {
            return "\"\"";
        }
        if (value.indexOf(44) < 0 && value.indexOf(34) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append('\"').append(c);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    protected BaseTag(String text, boolean escapeText, int characterWidth, Alignment align, boolean emphasizeText, String styleClass, Color bgColor, TextOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.styleClass = styleClass;
        this.text = text == null ? "NULL" : text;
        this.escapeText = escapeText;
        this.characterWidth = characterWidth;
        this.align = align;
        this.bgColor = bgColor;
        this.emphasizeText = emphasizeText;
        this.attributes = new HashMap<String, String>();
    }

    public String addAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public String toString() {
        if (this.outputFormat == TextOutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    protected abstract String getTag();

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<").append(this.getTag());
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            buffer.append(" ").append(attribute.getKey()).append("='").append(attribute.getValue()).append("'");
        }
        if (this.bgColor != null && !this.bgColor.equals((Object)Color.white)) {
            buffer.append(" bgcolor='").append(this.bgColor).append("'");
        }
        if (!Utility.isBlank((CharSequence)this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        } else if (this.align != null && this.align != Alignment.inherit) {
            buffer.append(" align='").append((Object)this.align).append("'");
        }
        buffer.append(">");
        if (this.emphasizeText) {
            buffer.append("<b><i>");
        }
        buffer.append(this.escapeText ? Entities.escapeForXMLElement(this.text) : this.text);
        if (this.emphasizeText) {
            buffer.append("</i></b>");
        }
        buffer.append("</").append(this.getTag()).append(">");
        return buffer.toString();
    }

    private String toPlainTextString() {
        if (this.outputFormat == TextOutputFormat.csv) {
            return this.escapeText ? BaseTag.escapeAndQuoteCsv(this.text) : this.text;
        }
        if (this.outputFormat == TextOutputFormat.tsv) {
            return this.text;
        }
        if (this.characterWidth > 0) {
            String format = String.format("%%%s%ds", this.align == Alignment.right ? "" : "-", this.characterWidth);
            return String.format(format, this.text);
        }
        return this.text;
    }
}

