/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import com.annimon.stream.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public enum InfoLevel {
    unknown,
    minimum,
    standard,
    detailed,
    maximum;

    private static final SchemaCrawlerLogger LOGGER;

    public static InfoLevel valueOfFromString(String infoLevelValue) {
        try {
            return InfoLevel.valueOf(infoLevelValue);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.log(Level.INFO, (Supplier)new StringFormat("Unknown infolevel <%s>", new Object[]{infoLevelValue}));
            return unknown;
        }
    }

    public final SchemaInfoLevel buildSchemaInfoLevel() {
        SchemaInfoLevel schemaInfoLevel;
        switch (this) {
            case minimum: {
                schemaInfoLevel = SchemaInfoLevelBuilder.minimum();
                break;
            }
            case standard: {
                schemaInfoLevel = SchemaInfoLevelBuilder.standard();
                break;
            }
            case detailed: {
                schemaInfoLevel = SchemaInfoLevelBuilder.detailed();
                break;
            }
            case maximum: {
                schemaInfoLevel = SchemaInfoLevelBuilder.maximum();
                break;
            }
            default: {
                schemaInfoLevel = SchemaInfoLevelBuilder.standard();
            }
        }
        schemaInfoLevel.setTag(this.name());
        return schemaInfoLevel;
    }

    static {
        LOGGER = SchemaCrawlerLogger.getLogger((String)InfoLevel.class.getName());
    }
}

