/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import com.annimon.stream.function.Supplier;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.OutputResource;
import schemacrawler.tools.iosource.OutputWriter;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class FileOutputResource
implements OutputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)FileOutputResource.class.getName());
    private final Path outputFile;

    public FileOutputResource(Path filePath) {
        this.outputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Writer openNewOutputWriter(Charset charset, boolean appendOutput) throws IOException {
        Objects.requireNonNull(charset, "No output charset provided");
        OpenOption[] openOptions = appendOutput ? new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND} : new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        BufferedWriter writer = Files.newBufferedWriter(this.outputFile, charset, openOptions);
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Opened output writer to file <%s>", new Object[]{this.outputFile}));
        return new OutputWriter(this.getDescription(), writer, true);
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        return this.outputFile.toString();
    }
}

