/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import com.annimon.stream.function.Supplier;
import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.StagedExecutable;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public abstract class BaseStagedExecutable
extends BaseExecutable
implements StagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)BaseStagedExecutable.class.getName());

    protected BaseStagedExecutable(String command) {
        super(command);
    }

    @Override
    public final void execute(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws Exception {
        Objects.requireNonNull(connection, "No connection provided");
        Objects.requireNonNull(databaseSpecificOverrideOptions, "No database specific overrides provided");
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Executing SchemaCrawler command <%s>", new Object[]{this.getCommand()}));
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, String.format("Executable: %s", this.getClass().getName()));
            LOGGER.log(Level.CONFIG, ObjectToString.toString((Object)this.schemaCrawlerOptions));
            LOGGER.log(Level.CONFIG, ObjectToString.toString((Object)this.outputOptions));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, ObjectToString.toString((Object)this.additionalConfiguration));
        }
        SchemaCrawler schemaCrawler = new SchemaCrawler(connection, databaseSpecificOverrideOptions);
        Catalog catalog = schemaCrawler.crawl(this.schemaCrawlerOptions);
        this.executeOn(catalog, connection);
    }
}

